<?php $pageTitle = 'İptal Talebi'; ?>
@include("layouts.header")

<main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-resource-create-record-page fi-resource-currencies">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 white:text-white sm:text-3xl">
                        İptal Talebi Oluştur
                    </h1>
                </div>
            </header>

            <div class="">
                <div class="grid flex-1 auto-cols-fr gap-y-8">
                    <form method="post" class="fi-form grid gap-y-6" action="{{ route('cancel.request') }}">
                      @csrf
                        <input type="hidden" name="serviceid" value="{{ $serviceId }}" />
                        <div class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-fo-component-ctn gap-6">
                            <div style="--col-span-default: 1 / -1;" class="col-[--col-span-default]">
                                <section class="fi-section rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 white:bg-gray-900 white:ring-white/10" id="data.para-birimi-bilgileri">
                                    <header class="fi-section-header flex flex-col gap-3 px-6 py-4">
                                        <div class="flex items-center gap-3">
                                            <div class="grid flex-1 gap-y-1">
                                                <h3 class="fi-section-header-heading text-base font-semibold leading-6 text-gray-950 white:text-white">
                                                    İptal Talebi Birimleri
                                                </h3>
                                            </div>
                                        </div>
                                    </header>

                                    <div
                                        style="--cols-default: repeat(1, minmax(0, 1fr)); --cols-lg: repeat(2, minmax(0, 1fr)); --cols-xl: repeat(2, minmax(0, 1fr));"
                                        class="fi-section-content-ctn border-t border-gray-200 white:border-white/10"
                                    >
                                        <div class="fi-section-content p-6">
                                            <div class="grid grid-cols-[--cols-default] lg:grid-cols-[--cols-lg] fi-fo-component-ctn gap-6">
                                                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                    <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                        <div class="grid gap-y-2">
                                                            <div class="flex items-center gap-x-3 justify-between">
                                                                <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.name">
                                                                    <span class="text-sm font-medium leading-6 text-gray-950 white:text-white">İptal Nedeni<sup class="text-danger-600 white:text-danger-400 font-medium">*</sup> </span>
                                                                </label>
                                                            </div>

                                                            <div class="grid auto-cols-fr gap-y-2">
                                                                <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white white:bg-white/5 fi-fo-text-input overflow-hidden">
                                                                    <div class="min-w-0 flex-1">
                                                                        <textarea
                                                                            id="reason"
                                                                            name="reason"
                                                                            class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 white:text-white white:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3"
                                                                        ></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                                                    <div data-field-wrapper="" class="fi-fo-field-wrp">
                                                        <div class="grid gap-y-2">
                                                            <div class="flex items-center gap-x-3 justify-between">
                                                                <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.name">
                                                                    <span class="text-sm font-medium leading-6 text-gray-950 white:text-white"> İptal Türü<sup class="text-danger-600 white:text-danger-400 font-medium">*</sup> </span>
                                                                </label>
                                                            </div>

                                                            <div class="grid auto-cols-fr gap-y-2">
                                                                <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white white:bg-white/5 fi-fo-text-input overflow-hidden">
                                                                    <div class="min-w-0 flex-1">
                                                                      <select required class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 white:text-white white:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-3 pe-3" name="type">
                                                                        <option value="" disabled selected>Lütfen seçim yapın</option>
                                                                        <option value="Immediate">Hemen</option>
                                                                        <option value="End of Billing Period">Hizmet Süresi Sonunda</option>
                                                                      </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div style="margin-top: 15px;">
                                              @if (session('success'))
                                              <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 white:bg-gray-800 white:text-green-400" role="alert">
                                                <span class="font-medium">Başarılı! </span> {{ session('success') }}
                                              </div>
                                              @endif
                                              @if (session('error'))
                                              <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 white:bg-gray-800 white:text-red-400" role="alert">
                                                <span class="font-medium">Hata: </span> {{ session('error') }}
                                              </div>
                                              @endif
                                            </div>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>

                        <div class="fi-form-actions">
                            <div class="fi-ac gap-3 flex flex-wrap items-center justify-start">
                                <button
                                    style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);"
                                    class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 white:bg-custom-500 white:hover:bg-custom-400 white:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action"
                                    type="submit"
                                >
                                    <span class="fi-btn-label">
                                        Talep Oluştur
                                    </span>
                                </button>

                                <a href="https://sspanel.serversistemleri.com/hostings/details/{{ $serviceId }}" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg  fi-btn-color-gray fi-color-gray fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-white text-gray-950 hover:bg-gray-50 white:bg-white/5 white:text-white white:hover:bg-white/10 ring-1 ring-gray-950/10 white:ring-white/20 fi-ac-action fi-ac-btn-action"><span class="fi-btn-label">
                                    Geri
                                </span></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
</main>



@include("layouts.footer")
