<?php $pageTitle = 'Giriş Yap'; ?>
<!DOCTYPE html>
<html lang="tr" dir="ltr" class="fi min-h-screen">
    <head>
        <meta charset="utf-8" />
        <meta name="csrf-token" content="MoRgCsS88i8UUxarcBc32Cy6D2InNztyLbCEw24c" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="robots" content="noindex, nofollow">
        <link rel="icon" href="https://serversistemleri.com/assets/img/favicon-96x96.png" />

        <title>
            {{ $pageTitle }} - Server Sistemleri
        </title>

        <style>
            [x-cloak=""],
            [x-cloak="x-cloak"],
            [x-cloak="1"] {
                display: none !important;
            }

            @media (max-width: 1023px) {
                [x-cloak="-lg"] {
                    display: none !important;
                }
            }

            @media (min-width: 1024px) {
                [x-cloak="lg"] {
                    display: none !important;
                }
            }
        </style>

        <link href="https://sspanel.serversistemleri.com/css/filament/forms/forms.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />
        <link href="https://sspanel.serversistemleri.com/css/dark-light.css" rel="stylesheet" data-navigate-track />
        <link href="https://sspanel.serversistemleri.com/css/filament/support/support.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

        <style>
            :root {
                --danger-50: 254, 242, 242;
                --danger-100: 254, 226, 226;
                --danger-200: 254, 202, 202;
                --danger-300: 252, 165, 165;
                --danger-400: 248, 113, 113;
                --danger-500: 239, 68, 68;
                --danger-600: 220, 38, 38;
                --danger-700: 185, 28, 28;
                --danger-800: 153, 27, 27;
                --danger-900: 127, 29, 29;
                --danger-950: 69, 10, 10;
                --gray-50: 250, 250, 250;
                --gray-100: 244, 244, 245;
                --gray-200: 228, 228, 231;
                --gray-300: 212, 212, 216;
                --gray-400: 161, 161, 170;
                --gray-500: 113, 113, 122;
                --gray-600: 82, 82, 91;
                --gray-700: 63, 63, 70;
                --gray-800: 39, 39, 42;
                --gray-900: 24, 24, 27;
                --gray-950: 9, 9, 11;
                --info-50: 239, 246, 255;
                --info-100: 219, 234, 254;
                --info-200: 191, 219, 254;
                --info-300: 147, 197, 253;
                --info-400: 96, 165, 250;
                --info-500: 59, 130, 246;
                --info-600: 37, 99, 235;
                --info-700: 29, 78, 216;
                --info-800: 30, 64, 175;
                --info-900: 30, 58, 138;
                --info-950: 23, 37, 84;
                --primary-50: 244, 250, 252;
                --primary-100: 232, 244, 249;
                --primary-200: 198, 228, 241;
                --primary-300: 164, 211, 232;
                --primary-400: 96, 179, 215;
                --primary-500: 28, 146, 198;
                --primary-600: 25, 131, 178;
                --primary-700: 21, 110, 149;
                --primary-800: 17, 88, 119;
                --primary-900: 14, 72, 97;
                --primary-950: 8, 44, 59;
                --success-50: 240, 253, 244;
                --success-100: 220, 252, 231;
                --success-200: 187, 247, 208;
                --success-300: 134, 239, 172;
                --success-400: 74, 222, 128;
                --success-500: 34, 197, 94;
                --success-600: 22, 163, 74;
                --success-700: 21, 128, 61;
                --success-800: 22, 101, 52;
                --success-900: 20, 83, 45;
                --success-950: 5, 46, 22;
                --warning-50: 255, 251, 235;
                --warning-100: 254, 243, 199;
                --warning-200: 253, 230, 138;
                --warning-300: 252, 211, 77;
                --warning-400: 251, 191, 36;
                --warning-500: 245, 158, 11;
                --warning-600: 217, 119, 6;
                --warning-700: 180, 83, 9;
                --warning-800: 146, 64, 14;
                --warning-900: 120, 53, 15;
                --warning-950: 69, 26, 3;
            }
        </style>

        <link href="https://sspanel.serversistemleri.com/css/filament/filament/app.css?v=3.2.92.0" rel="stylesheet" data-navigate-track />

        <link rel="preconnect" href="https://fonts.bunny.net" />
        <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet" />

        <style>
            :root {
                --font-family: "Inter";
                --sidebar-width: 20rem;
                --collapsed-sidebar-width: 4.5rem;
                --default-theme-mode: light;
            }
        </style>
        <script type="text/javascript">

        </script>


        <!-- Livewire Styles -->
        <style>
            [wire\:loading][wire\:loading],
            [wire\:loading\.delay][wire\:loading\.delay],
            [wire\:loading\.inline-block][wire\:loading\.inline-block],
            [wire\:loading\.inline][wire\:loading\.inline],
            [wire\:loading\.block][wire\:loading\.block],
            [wire\:loading\.flex][wire\:loading\.flex],
            [wire\:loading\.table][wire\:loading\.table],
            [wire\:loading\.grid][wire\:loading\.grid],
            [wire\:loading\.inline-flex][wire\:loading\.inline-flex] {
                display: none;
            }
            [wire\:loading\.delay\.none][wire\:loading\.delay\.none],
            [wire\:loading\.delay\.shortest][wire\:loading\.delay\.shortest],
            [wire\:loading\.delay\.shorter][wire\:loading\.delay\.shorter],
            [wire\:loading\.delay\.short][wire\:loading\.delay\.short],
            [wire\:loading\.delay\.default][wire\:loading\.delay\.default],
            [wire\:loading\.delay\.long][wire\:loading\.delay\.long],
            [wire\:loading\.delay\.longer][wire\:loading\.delay\.longer],
            [wire\:loading\.delay\.longest][wire\:loading\.delay\.longest] {
                display: none;
            }
            [wire\:offline][wire\:offline] {
                display: none;
            }
            [wire\:dirty]:not(textarea):not(input):not(select) {
                display: none;
            }
            :root {
                --livewire-progress-bar-color: #2299dd;
            }
            [x-cloak] {
                display: none !important;
            }
        </style>

        <style>
            @keyframes checkmark {
                0% {
                    stroke-dashoffset: 100;
                }
                100% {
                    stroke-dashoffset: 0;
                }
            }
            @keyframes scaleIn {
                0% {
                    transform: scale(0);
                    opacity: 0;
                }
                50% {
                    transform: scale(1.1);
                }
                100% {
                    transform: scale(1);
                    opacity: 1;
                }
            }
            .success-checkmark {
                animation: scaleIn 0.5s ease-in-out;
            }
            .success-checkmark__check {
                transform-origin: 50% 50%;
                stroke-dasharray: 100;
                stroke-dashoffset: 100;
                animation: checkmark 0.6s 0.2s ease-in-out forwards;
            }

            /* Responsive improvements */
            @media (max-width: 640px) {
                .fi-simple-main {
                    margin-top: 0 !important;
                    margin-bottom: 0 !important;
                    border-radius: 0 !important;
                    min-height: 100vh;
                }
                .fi-simple-header img {
                    width: 180px !important;
                }
                .grid.grid-cols-\[--cols-default\] {
                    grid-template-columns: 1fr !important;
                }
            }
        </style>
    </head>
    <body class="fi-body fi-panel-admin min-h-screen bg-gray-50 font-normal text-gray-950 antialiased dark:bg-gray-950 dark:text-white">

<div class="fi-simple-layout flex min-h-screen flex-col items-center">
  <div class="fi-simple-main-ctn flex w-full flex-grow items-center justify-center">
      <main class="fi-simple-main my-16 w-full bg-white px-6 py-12 shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 sm:rounded-xl sm:px-12 sm:max-w-lg">
          <div class="fi-simple-page">
              <section class="grid auto-cols-fr gap-y-6">
                  <header class="fi-simple-header flex flex-col items-center">
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_white.webp" class="l-none fi-logo mb-4" style="width: 250px;" />
                      <img alt="Server Sistemleri" src="https://sspanel.serversistemleri.com/img/logo_dark.webp" class="d-none fi-logo mb-4" style="width: 250px;" />
                      <h1 class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                          Giriş Yap
                      </h1>
                  </header>

                  <form action="{{ route('login') }}" method="POST" class="fi-form grid gap-y-6" id="form">
                      @csrf
                      <div style="--cols-default: repeat(1, minmax(0, 1fr));" class="grid grid-cols-[--cols-default] fi-fo-component-ctn gap-6">
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.email">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  E-Posta Adresi
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="email"
                                                      id="data.email"
                                                      name="email"
                                                      placeholder="ornek@email.com"
                                                      required
                                                      autocomplete="email"
                                                      autofocus
                                                      tabindex="1"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div style="--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center justify-between gap-x-3">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.password">
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  Şifre
                                                  <sup class="text-danger-600 dark:text-danger-400 font-medium">*</sup>
                                              </span>
                                          </label>
                                          <div class="fi-fo-field-wrp-hint flex items-center gap-x-3 text-sm">
                                              <span class="fi-fo-field-wrp-hint-label text-gray-500 fi-color-gray">
                                                  <a href="/password-reset" class="fi-link group/link relative inline-flex items-center justify-center outline-none fi-size-md fi-link-size-md gap-1.5 fi-color-custom fi-color-primary" tabindex="3">
                                                      <span class="font-semibold group-hover/link:underline group-focus-visible/link:underline text-sm text-custom-600 dark:text-custom-400">
                                                          Şifrenizi mi unuttunuz?
                                                      </span>
                                                  </a>
                                              </span>
                                          </div>
                                      </div>
                                      <div class="grid auto-cols-fr gap-y-2">
                                          <div class="fi-input-wrp flex rounded-lg shadow-sm ring-1 transition duration-75 bg-white dark:bg-white/5 focus-within:ring-2 ring-gray-950/10 dark:ring-white/20 focus-within:ring-primary-600 dark:focus-within:ring-primary-500 fi-fo-text-input overflow-hidden">
                                              <div class="flex items-center ps-3 text-gray-400">
                                                  <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                                                  </svg>
                                              </div>
                                              <div class="min-w-0 flex-1">
                                                  <input
                                                      type="password"
                                                      id="data.password"
                                                      name="password"
                                                      placeholder="Şifreniz"
                                                      required
                                                      autocomplete="current-password"
                                                      tabindex="2"
                                                      class="fi-input block w-full border-none py-1.5 text-base text-gray-950 transition duration-75 placeholder:text-gray-400 focus:ring-0 disabled:text-gray-500 dark:text-white dark:placeholder:text-gray-500 sm:text-sm sm:leading-6 bg-white/0 ps-2 pe-3" />
                                              </div>
                                              <button type="button" onclick="togglePassword('data.password')" class="px-3 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition-colors" aria-label="Şifreyi göster/gizle">
                                                  <svg id="data.password-eye-open" class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                                  </svg>
                                                  <svg id="data.password-eye-closed" class="h-5 w-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"/>
                                                  </svg>
                                              </button>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div style="display:none;--col-span-default: span 1 / span 1;" class="col-[--col-span-default]">
                              <div data-field-wrapper="" class="fi-fo-field-wrp">
                                  <div class="grid gap-y-2">
                                      <div class="flex items-center gap-x-3 justify-between">
                                          <label class="fi-fo-field-wrp-label inline-flex items-center gap-x-3" for="data.remember">
                                              <input name="remember" type="checkbox" class="fi-checkbox-input rounded border-none bg-white shadow-sm ring-1 transition duration-75 checked:ring-0 focus:ring-2 focus:ring-offset-0 disabled:pointer-events-none disabled:bg-gray-50 disabled:text-gray-50 disabled:checked:bg-current disabled:checked:text-gray-400 dark:bg-white/5 dark:disabled:bg-transparent dark:disabled:checked:bg-gray-600 text-primary-600 ring-gray-950/10 focus:ring-primary-600 checked:focus:ring-primary-500/50 dark:text-primary-500 dark:ring-white/20 dark:checked:bg-primary-500 dark:focus:ring-primary-500 dark:checked:focus:ring-primary-400/50 dark:disabled:ring-white/10"/>
                                              <span class="text-sm font-medium leading-6 text-gray-950 dark:text-white">
                                                  Beni Hatırla
                                              </span>
                                          </label>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <div class="fi-form-actions">
                          <div class="fi-ac gap-3 grid grid-cols-[repeat(auto-fit,minmax(0,1fr))]">
                              <button style="--c-400: var(--primary-400); --c-500: var(--primary-500); --c-600: var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom-400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action" type="submit" id="submit-button">
                                  <span class="fi-btn-label">GİRİŞ YAP</span>
                              </button>
                          </div>
                      </div>

                      <div class="text-center mt-4">
                          <p class="text-sm text-gray-600 dark:text-gray-400">
                              Henüz hesabınız yok mu?
                              <a href="{{ route('register') }}" class="text-primary-600 hover:text-primary-700 dark:text-primary-400 dark:hover:text-primary-300 font-medium transition-colors duration-200">
                                  Kayıt Olun
                              </a>
                          </p>
                      </div>
                  </form>

                  @if($errors->any())
                  <div class="bg-red-50 dark:bg-gray-800 dark:text-red-400 flex items-center p-4 rounded-lg text-red-800 text-sm" role="alert">
                      <svg style="margin-right: 5px;" aria-hidden="true" class="flex-shrink-0 h-4 inline me-3 w-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                          <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                      </svg>
                      <span class="sr-only">Hata</span>
                      <div><span class="font-medium">Hata!</span> {{ $errors->first() }}</div>
                  </div>
                  @endif
              </section>
          </div>
      </main>
  </div>
</div>
<script>
    // Password toggle function
    function togglePassword(inputId) {
        const input = document.getElementById(inputId);
        const eyeOpen = document.getElementById(inputId + '-eye-open');
        const eyeClosed = document.getElementById(inputId + '-eye-closed');

        if (input.type === 'password') {
            input.type = 'text';
            eyeOpen.classList.add('hidden');
            eyeClosed.classList.remove('hidden');
        } else {
            input.type = 'password';
            eyeOpen.classList.remove('hidden');
            eyeClosed.classList.add('hidden');
        }
    }

    // Form submit handler
    document.getElementById('form').addEventListener('submit', function() {
        var submitButton = document.getElementById('submit-button');
        submitButton.disabled = true;
        submitButton.innerHTML = "Lütfen bekleyiniz...";
    });
</script>

<script src="https://sspanel.serversistemleri.com/js/filament/notifications/notifications.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/async-alpine.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/support/support.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/echo.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/filament/filament/app.js?v=3.2.92.0" data-navigate-once data-navigate-track></script>
<script src="https://sspanel.serversistemleri.com/js/livewire.js" data-navigate-once data-navigate-track></script>

</body>
</html>
