<?php
namespace EFatura;

class Client
{
    private $session_id = null;
    private $hata;

    public function __construct($service_url)
    {
        Util::$service_url = $service_url;
    }

    public function getHata()
    {
        return $this->hata;
    }

    public function setHata($hataKod, $hataMesaj)
    {
        $this->hata = array(
            "KOD" => $hataKod,
            "MESAJ" => $hataMesaj
        );
    }


    public function getSessionId()
    {
        return (is_null($this->session_id) ? $_SESSION["EFATURA_SESSION"] : $this->session_id);
    }

    public function setSessionId($session_id)
    {
        $_SESSION["EFATURA_SESSION"] = $session_id;
        $this->session_id = $session_id;
    }

    public function login($username, $password)
    {
        $header = new RequestHeader();
        $header->session_id = "-1";
        $param = $header->getArray();
        $param["USER_NAME"] = $username;
        $param["PASSWORD"] = $password;
        $request = new Request();
        $session = $request->send("Login", $param);
        if ($session->SESSION_ID != "") {
            $this->setSessionId($session->SESSION_ID);
            return true;
        } else {
            $this->setHata($request->hataKod, $request->hataMesaj);
            return false;
        }
    }


    public function getSingleInvoice($faturaNo = null, $faturaUUID = null, $gelen = false, $contentType = "PDF")
    {
        if (is_null($faturaNo) && is_null($faturaUUID)) {
            return false;
        } else {
            $req_header = new RequestHeader();
            $req_header->session_id = $this->getSessionId();
            $send_data = $req_header->getArray();

            $send_data["INVOICE_CONTENT_TYPE"] = $contentType;
            $send_data["HEADER_ONLY"] = "N";
            $send_data["INVOICE_SEARCH_KEY"]["LIMIT"] = 1;
            $send_data["INVOICE_SEARCH_KEY"]["LIMITSpecified"] = true;

            $send_data["INVOICE_SEARCH_KEY"]["DIRECTION"] = ($gelen ? "IN" : "OUT");
            $send_data["INVOICE_SEARCH_KEY"]["ID"] = $faturaNo;

            $req = new Request();
            $sonuc = $req->send("GetInvoice", $send_data);
            $this->setHata($req->hataKod, $req->hataMesaj);
            return array(
                "CONTENT" => $sonuc->INVOICE->CONTENT->_,
                "SENDER" => $sonuc->INVOICE->HEADER->SENDER,
                "RECEIVER" => $sonuc->INVOICE->HEADER->RECEIVER,
                "SUPPLIER" => $sonuc->INVOICE->HEADER->SUPPLIER,
                "CUSTOMER" => $sonuc->INVOICE->HEADER->CUSTOMER,
                "ISSUE_DATE" => $sonuc->INVOICE->HEADER->ISSUE_DATE,
                "PAYABLE_AMOUNT" => $sonuc->INVOICE->HEADER->PAYABLE_AMOUNT->_ . " " . $sonuc->INVOICE->HEADER->PAYABLE_AMOUNT->currencyID,
                "PARABIRIMI" => $sonuc->INVOICE->HEADER->PAYABLE_AMOUNT->currencyID,
                "FROM" => $sonuc->INVOICE->HEADER->FROM,
                "TO" => $sonuc->INVOICE->HEADER->TO,
                "PROFILEID" => $sonuc->INVOICE->HEADER->PROFILEID,
                "STATUS" => $sonuc->INVOICE->HEADER->STATUS,
                "STATUS_DESCRIPTION" => $sonuc->INVOICE->HEADER->STATUS_DESCRIPTION,
                "ACIKLAMA" => Util::invoiceStatus($sonuc->INVOICE->HEADER->STATUS),
                "STATUS" => $sonuc->INVOICE->HEADER->STATUS,
                "GIB_STATUS_CODE" => $sonuc->INVOICE->HEADER->GIB_STATUS_CODE,
                "GIB_STATUS_DESCRIPTION" => $sonuc->INVOICE->HEADER->GIB_STATUS_DESCRIPTION,
                "RESPONSE_CODE" => $sonuc->INVOICE->HEADER->RESPONSE_CODE,
                "RESPONSE_DESCRIPTION" => $sonuc->INVOICE->HEADER->RESPONSE_DESCRIPTION,
                "FILENAME" => $sonuc->INVOICE->HEADER->FILENAME,
                "HASH" => $sonuc->INVOICE->HEADER->HASH,
                "CDATE" => $sonuc->INVOICE->HEADER->CDATE,
                "ENVELOPE_IDENTIFIER" => $sonuc->INVOICE->HEADER->ENVELOPE_IDENTIFIER,
                "INTERNETSALES" => $sonuc->INVOICE->HEADER->INTERNETSALES,
                "EARCHIVE" => $sonuc->INVOICE->HEADER->EARCHIVE,
                "TRXID" => $sonuc->INVOICE->TRXID,
                "UUID" => $sonuc->INVOICE->UUID,
                "ID" => $sonuc->INVOICE->ID
            );
        }
    }
}

$client = new \EFatura\Client("https://link.edmbilisim.com.tr/EFaturaEDM/EFaturaEDM.svc?singleWsdl");
