<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DatabaseController extends Controller
{

  public function UserLoginController($table, $conditions, $updateData)
    {
        try {
            // Veritabanı güncelleme işlemini gerçekleştir
            $result = DB::connection('whmcs')->table($table)
                ->where($conditions)
                ->update($updateData);

            // İşlem sonucunu döndür
            return $result;
        } catch (\Exception $e) {
            // Hata durumunda hata mesajını döndür
            return ['error' => $e->getMessage()];
        }
    }

    public function addLog($name, $client_id, $description)
    {
      if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
          $user_ip = $_SERVER['HTTP_CLIENT_IP'];
      } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
          $user_ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
      } else {
          $user_ip = $_SERVER['REMOTE_ADDR'];
      }
      $hostname = gethostbyaddr($user_ip);

      $ip_address = $user_ip . ' ' . $hostname;
    date_default_timezone_set('Europe/Istanbul');
    try {
        // Yeni kaydı ekle, herhangi bir yanıt döndürme
        DB::connection('whmcs')->table('sspanel_logs')->insert([
            'name' => $name,
            'client_id' => $client_id,
            'description' => $description,
            'log_date' =>  date('d-m-Y H:i:s'),
            'ip_address' => $ip_address
        ]);
    } catch (\Exception $e) {
        // Hata durumunda bile herhangi bir yanıt dönme
    }
}


public function application($client_id)
{
    try {
        // Eğer client_id varsa ekleme yapma
        $exists = DB::connection('whmcs')->table('application')->where('client_id', $client_id)->exists();

        if (!$exists) {

            date_default_timezone_set('Europe/Istanbul');

            DB::connection('whmcs')->table('application')->insert([
                'client_id' => $client_id,
                'create_date' => date('d-m-Y H:i:s'),
            ]);
        }
    } catch (\Exception $e) {
        // Hata durumunda herhangi bir işlem yapma
    }
}

public function InsertData(string $table, array $data, ?string $uniqueField = null)
{
    try {
        $query = DB::connection('whmcs')->table($table);

        // Eğer uniqueField varsa, aynı kayıt daha önce eklenmiş mi kontrol et
        if ($uniqueField && isset($data[$uniqueField])) {
            $exists = $query->where($uniqueField, $data[$uniqueField])->exists();
            if ($exists) {
                return false; // Aynısı varsa ekleme
            }
        }

        // created_at yoksa ekle
        if (!isset($data['created_at'])) {
            $data['created_at'] = now();
        }

        return $query->insert($data);
    } catch (\Exception $e) {
        \Log::error("Veritabanı ekleme hatası: [$table] " . $e->getMessage(), [
            'data' => $data
        ]);
        return false;
    }
}

    public function GetData($table, $conditions = [])
    {
      try {
        // Koşul varsa, koşullara göre filtreleyerek veriyi getir
        $query = DB::connection('whmcs')->table($table);

        if (!empty($conditions)) {
            $query->where($conditions);
          }

          $result = $query->get();

          // İşlem sonucunu döndür
          return $result;
        } catch (\Exception $e) {
          // Hata durumunda hata mesajını döndür
          return ['error' => $e->getMessage()];
        }
      }
      public function getClientById($id)
      {
          try {
              return DB::connection('whmcs')->table('tblclients')
                  ->where('id', $id)
                  ->first();
          } catch (\Exception $e) {
              \Log::error("Client verisi alınamadı: " . $e->getMessage());
              return null;
          }
      }

      public function getTokenRecord($token)
{
    try {
        return DB::connection('whmcs')->table('sspanel_token')
            ->where('token', $token)
            ->first();
    } catch (\Exception $e) {
        \Log::error("Token kaydı alınamadı: " . $e->getMessage());
        return null;
    }
}

}
