<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhmcsService;
use Illuminate\Support\Facades\Session;

class DashboardController extends Controller
{
    protected $whmcs;

    public function __construct(WhmcsService $whmcs)
    {
        $this->whmcs = $whmcs;
    }

    public function index()
    {
        $clientId = Session::get('client');

        if ($clientId) {
            $clientDetails = $this->whmcs->getClientDetails($clientId);

            if ($clientDetails['result'] === 'success') {
                return view('dashboard', [
                    'firstname' => $clientDetails['firstname'],
                    'lastname' => $clientDetails['lastname'],
                ]);
            }
        }

        return redirect()->route('login');
    }
}
