<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhmcsService;
use App\Services\TopluSmsService;
use Illuminate\Support\Facades\Session;
use SoapClient;
use Exception;

class ClientController extends Controller
{
    protected $whmcs;
    protected $smsService;

    public function __construct(WhmcsService $whmcs, TopluSmsService $smsService)
    {
        $this->whmcs = $whmcs;
        $this->smsService = $smsService;
    }

    public function updateClient(Request $request)
    {
        $clientId = Session::get('client');
        $firstname = $request->input('firstname');
        $lastname = $request->input('lastname');
        $customfields2 = $request->input('customfields2'); // TC Kimlik Numarası
        $customfields3 = $request->input('customfields3'); // Doğum Yılı
        $customfields4 = $request->input('customfields4');
        $customfields5 = $request->input('customfields5');
        $customfields6 = $request->input('phonenumber');
        $companyname = $request->input('companyname');
        $email = $request->input('email');
        $country = $request->input('country');
        $postcode = $request->input('postcode');
        $city = $request->input('city');
        $state = $request->input('state');
        $address1 = $request->input('address1');
        $membertype = $request->input('membertype');

        if (!preg_match('/^[1-9][0-9]{10}$/', $customfields2)) {
            return response()->json(['status' => 'error', 'message' => 'Geçersiz TC Kimlik Numarası. TC Kimlik Numarası 11 haneli ve yalnızca rakamlardan oluşmalıdır.']);
        }

        // Doğum Yılı doğrulama
        if (!preg_match('/^\d{4}$/', $customfields3) || $customfields3 < 1900 || $customfields3 > date('Y')) {
            return response()->json(['status' => 'error', 'message' => 'Geçersiz Doğum Yılı. Doğum Yılı 4 haneli olmalı ve 1900 ile bugünkü yıl arasında olmalıdır.']);
        }

        try {
            $response = $this->whmcs->UpdateClient(
                $clientId,
                $firstname,
                $lastname,
                $customfields2, // TCKimlik (artık doğrulama yapılmıyor ama kayıt ediliyor)
                $customfields3, // Doğum yılı
                $customfields4,
                $customfields5,
                $customfields6,
                $companyname,
                $email,
                $country,
                $postcode,
                $city,
                $state,
                $address1,
                $membertype
            );

            if (is_array($response) && isset($response['result'])) {
                if ($response['result'] == 'success') {
                    return response()->json([
                        'status' => 'success',
                        'message' => 'Profil verileriniz başarı ile güncellendi!'
                    ]);
                } else {
                    return response()->json([
                        'status' => 'error',
                        'message' => 'Profil verilerinizin düzenlemesi başarısız. Hata: ' . $response['message']
                    ]);
                }
            } else {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Ne olduğu belirsiz!'
                ]);
            }
        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Bir hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    public function register(Request $request) {
      $firstname   = $request->input('firstname');
      $lastname    = $request->input('lastname');
      $email       = $request->input('email');
      $password    = $request->input('password');
      $password2   = $request->input('password2');
      $tckimlikno  = $request->input('tckimlikno');
      $dogumyili   = $request->input('dogumyili');
      $phone       = $request->input('phonenumber');
      $action      = $request->input('mobilactions');

      // Şifre eşleşme kontrolü
      if ($password !== $password2) {
          return response()->json(['status' => 'error', 'message' => 'Şifreler Eşleşmiyor!']);
      }

      // Telefon numarası sadece 10 hane olarak normalize edilir (5394370279 gibi)
      $rawPhone = preg_replace('/\D+/', '', $phone); // sadece rakamları al

      if (substr($rawPhone, 0, 2) === '90') {
          $rawPhone = substr($rawPhone, 2);
      }

      if (substr($rawPhone, 0, 1) === '0') {
          $rawPhone = substr($rawPhone, 1);
      }

      if (strlen($rawPhone) === 10) {
          $phone = $rawPhone;
      } else {
          return response()->json(['status' => 'error', 'message' => 'Geçersiz telefon numarası. Lütfen geçerli bir numara giriniz.']);
      }

      // Eğer sadece mobil kayıt ise
      if ($action === "SSMobil") {
      // SSMobil için önceki davranışı korudum: TC/DY göndermiyoruz
      $response = $this->whmcs->AddClient(
          $firstname,
          $lastname,
          $email,
          $password,
          null,
          null,
          $phone
      );

      if ($response['result'] == 'success') {
          return response()->json([
              'status' => 'success',
              'message' => 'Kayıt başarı ile gerçekleştirildi! Giriş sayfasına yönlendiriliyorsunuz!'
          ]);
      } else {
          return response()->json([
              'status' => 'error',
              'message' => $response['message'] . '!'
          ]);
      }

  } else {
      // Doğrulama YOK: TC ve Doğum Yılı direkt kayda gönderiliyor
      $response = $this->whmcs->AddClient(
          $firstname,
          $lastname,
          $email,
          $password,
          $tckimlikno, // doğrulama yok, direkt kayda yazılıyor
          $dogumyili,  // doğrulama yok, direkt kayda yazılıyor
          $phone
      );

      if ($response['result'] == 'success') {
          return response()->json([
              'status' => 'success',
              'message' => 'Kayıt başarı ile gerçekleştirildi! Giriş sayfasına yönlendiriliyorsunuz!'
          ]);
      } else {
          return response()->json([
              'status' => 'error',
              'message' => $response['message'] . '!'
          ]);
      }
  }
  }

    public function showRegister()
    {
        return view('auth.register');
    }

    public function sendVerifyMail(){
      $clientId = Session::get('client');
      $response = $this->whmcs->sendVerifyMail($clientId);

      if ($response['result'] == 'success') {
          return response()->json(['status' => 'success', 'message' => 'Doğrulama Kodu başarılı bir şekilde mail adresinize gönderildi.']);
      } else {
          return response()->json(['status' => 'error', 'message' => 'Bir hata oluştu. Lütfen tekrar deneyin.']);
      }
    }

    public function VerifyEmail($verificationcode)
    {
        $clientId = Session::get('client');
        $response = $this->whmcs->VerifyEmail([
            'verificationcode' => $verificationcode
        ]);

        if ($response['result'] == 'success') {
            $message = 'Doğrulama işlemi başarılı bir şekilde gerçekleştirildi.';
        } else {
            $message = 'Doğrulama işlemi zaten yapılmış veya doğrulama kodunuzun süresi dolmuş.';
        }

        return view('auth.everify', ['message' => $message]);
    }
}
