<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhmcsService;

class CancellationController extends Controller
{
    protected $whmcs;

    public function __construct(WhmcsService $whmcs)
    {
        $this->whmcs = $whmcs;
    }

    public function requestCancellation(Request $request)
    {
        $serviceId = $request->input('serviceid');
        $reason = $request->input('reason');
        $type = $request->input('type');

        $response = $this->whmcs->addCancelRequest($serviceId, $reason, $type);

        if ($response['result'] === 'success') {
            return redirect()->back()->with('success', 'İptal talebiniz başarı ile oluşturuldu.');
        } else {
            return redirect()->back()->with('error', 'İptal talebi gönderilirken bir hata oluştu, iptal talebi mevcut veya sistemsel bir sorun oluştu');
        }
    }
}
