<?php

namespace App\Filament\Resources\VehicleResource\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Filament\Widgets\StatsOverviewWidget\Card;

use App\Models\Vehicle;

use Illuminate\Support\Facades\DB;

class StatsOverview extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    // protected function getStats(): array
    // {
    //     return [
    //         Stat::make('Toplam Araç', Vehicle::count())
    //             ->description('Tümünü Göster')
    //             ->descriptionIcon('heroicon-m-arrow-small-right'),

    //         Stat::make('Çekici Sayısı', Vehicle::where('vehicle_type_id', 2)->count())
    //             ->description('Tümünü Göster')
    //             ->descriptionIcon('heroicon-m-arrow-small-right'),

    //         Stat::make('Dorse Sayısı', Vehicle::where('vehicle_type_id', 3)->count())
    //             ->description('Tümünü Göster')
    //             ->descriptionIcon('heroicon-m-arrow-small-right'),

    //         Stat::make('Binek Araç Sayısı', Vehicle::where('vehicle_type_id', 1)->count())
    //             ->description('Tümünü Göster')
    //             ->descriptionIcon('heroicon-m-arrow-small-right'),
    //     ];
    // }

    protected function getCards(): array
    {
        return [
            Card::make('Toplam Araç', Vehicle::count())
                ->description('Tümünü Göster')
                ->descriptionIcon('heroicon-m-arrow-small-right')
                ->icon('heroicon-o-truck')
                ->url(route('filament.admin.resources.vehicles.index')),

            Card::make('Çekici Sayısı', Vehicle::where('vehicle_type_id', 2)->count())
                ->description('Tümünü Göster')
                ->descriptionIcon('heroicon-m-arrow-small-right')
                ->icon('heroicon-o-truck')
                ->url(route('filament.admin.resources.vehicles.index').'?activeTab=cekici'),

            Card::make('Dorse Sayısı', Vehicle::where('vehicle_type_id', 3)->count())
                ->description('Tümünü Göster')
                ->descriptionIcon('heroicon-m-arrow-small-right')
                ->icon('heroicon-o-truck')
                ->url(route('filament.admin.resources.vehicles.index').'?activeTab=dorse'),

            Card::make('Binek Araç Sayısı', Vehicle::where('vehicle_type_id', 1)->count())
                ->description('Tümünü Göster')
                ->descriptionIcon('heroicon-m-arrow-small-right')
                ->icon('heroicon-o-truck')
                ->url(route('filament.admin.resources.vehicles.index').'?activeTab=tasit'),
        ];
    }
}
