<?php

namespace App\Filament\Resources\EmployeeResource\Pages;

use App\Filament\Resources\EmployeeResource;
use Filament\Actions;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Pages\ManageRelatedRecords;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\MaxWidth;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Contracts\Support\Htmlable;

use Illuminate\Database\Eloquent\Model;

class ManageAttachments extends ManageRelatedRecords
{
    protected static string $resource = EmployeeResource::class;

    protected static string $relationship = 'attachments';

    protected static ?string $navigationIcon = 'heroicon-m-cloud-arrow-up';
    protected static ?string $navigationLabel = 'Dosyalar';

    private static ?string $modelLabel = 'Dosya Eki';

    public function getTitle(): string | Htmlable
    {
        return self::$navigationLabel;
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Başlık')
                    ->maxLength(255)
                    ->required()
                    ->default(date('Y-m-d H:i:s')),

                Forms\Components\FileUpload::make('attachments')
                    ->label('Dosya')
                    ->disk('attachments')
                    ->directory('employee')
                    ->visibility('private')
                    ->required(),

                Forms\Components\TextInput::make('disk')
                    ->label('Disk')
                    ->default('attachments'),

                Forms\Components\TextInput::make('size')
                    ->label('Başlık')
                    ->default(2048),
            ])
            ->columns(1);
    }

    public function table(Table $table): Table
    {
        return $table
            // ->recordTitleAttribute('name')
            // ->recordTitle(fn ($record): string => {$record->name})
            // ->heading('Clients')
            // ->description('Manage your clients here.')
            // ->modelLabel(self::$modelLabel)
            ->searchDebounce('1000ms')
            ->columns([
                Tables\Columns\ImageColumn::make('file_name')
                    ->label('#')
                    ->disk('attachments')
                    ->visibility('private')
                    ->circular(),

                Tables\Columns\TextColumn::make('name')
                    ->label('Açıklama')
                    ->description(fn ($record): ?string => $record->description)
                    ->weight(FontWeight::Medium)
                    ->searchable()
                    ->grow(true),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Oluşturma')
                    ->dateTime(),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Güncelleme')
                    ->dateTime(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->modelLabel(self::$modelLabel)
                    ->modalWidth(MaxWidth::Large)
                    ->slideOver()
                    ->createAnother(false),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    // Tables\Actions\ViewAction::make()
                    //     ->modalHeading(__('filament-actions::view.single.modal.heading', ['label' => self::$modelLabel]))
                    //     ->modalWidth(MaxWidth::Large)
                    //     ->slideOver(),

                    // Tables\Actions\EditAction::make()
                    //     ->modalHeading(__('filament-actions::edit.single.modal.heading', ['label' => self::$modelLabel]))
                    //     ->modalWidth(MaxWidth::Large)
                    //     ->slideOver(),

                    Tables\Actions\DeleteAction::make()
                        ->modalHeading(__('filament-actions::delete.single.modal.heading', ['label' => self::$modelLabel])),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->emptyStateHeading(__('filament-tables::table.empty.heading', ['model' => self::$modelLabel]))
            ->emptyStateDescription(__('filament-tables::table.empty.description', ['model' => self::$modelLabel]));
    }
}
