<?php

namespace App\Filament\Resources\ClientResource\Pages;

use App\Filament\Resources\ClientResource;
use Filament\Actions;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Pages\ManageRelatedRecords;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\MaxWidth;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Contracts\Support\Htmlable;

class ManagePhones extends ManageRelatedRecords
{
    protected static string $resource = ClientResource::class;

    protected static string $relationship = 'phones';

    protected static ?string $navigationIcon = 'heroicon-m-device-phone-mobile';
    protected static ?string $navigationLabel = 'Telefon Numaraları';

    private static ?string $modelLabel = 'Telefon Numarası';

    public function getTitle(): string | Htmlable
    {
        return self::$navigationLabel;
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Başlık')
                    ->placeholder('Kişisel, Yurtdışı, İş Hattı vb.')
                    ->maxLength(100)
                    ->required(),

                Forms\Components\TextInput::make('phone_number')
                    ->label('Telefon Numarası')
                    ->maxLength(15)
                    ->required(),

                Forms\Components\Toggle::make('is_primary')
                    ->label('Birincil Kullanım Durumu')
                    ->inline(false),
            ])
            ->columns(1);
    }

    public function table(Table $table): Table
    {
        return $table
            // ->recordTitleAttribute('name')
            // ->recordTitle(fn ($record): string => {$record->name})
            // ->heading('Clients')
            // ->description('Manage your clients here.')
            // ->modelLabel(self::$modelLabel)
            ->searchDebounce('1000ms')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Başlık')
                    ->weight(FontWeight::Medium)
                    ->searchable(),

                Tables\Columns\TextColumn::make('phone_number')
                    ->label('Telefon Numarası'),

                Tables\Columns\ToggleColumn::make('is_primary')
                    ->label('Birincil Kullanım')
                    ->afterStateUpdated(function ($record, $state) {
                        if ($state) {
                            $record->phoneable->phones()
                                ->where('id', '!=', $record->id)
                                ->update(['is_primary' => false]);
                        }
                    }),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Oluşturma')
                    ->dateTime()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Güncelleme')
                    ->dateTime()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->modelLabel(self::$modelLabel)
                    ->modalWidth(MaxWidth::Large)
                    ->slideOver()
                    ->createAnother(false)
                    ->after(function ($record) {
                        if ($record->is_primary) {
                            $record->phoneable->phones()
                                ->where('id', '!=', $record->id)
                                ->update(['is_primary' => false]);
                        }
                    }),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make()
                        ->modalHeading(__('filament-actions::view.single.modal.heading', ['label' => self::$modelLabel]))
                        ->modalWidth(MaxWidth::Large)
                        ->slideOver(),

                    Tables\Actions\EditAction::make()
                        ->modalHeading(__('filament-actions::edit.single.modal.heading', ['label' => self::$modelLabel]))
                        ->modalWidth(MaxWidth::Large)
                        ->slideOver()
                        ->after(function ($record) {
                            if ($record->is_primary) {
                                $record->phoneable->phones()
                                    ->where('id', '!=', $record->id)
                                    ->update(['is_primary' => false]);
                            }
                        }),

                    Tables\Actions\DeleteAction::make()
                        ->modalHeading(__('filament-actions::delete.single.modal.heading', ['label' => self::$modelLabel])),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->emptyStateHeading(__('filament-tables::table.empty.heading', ['model' => self::$modelLabel]))
            ->emptyStateDescription(__('filament-tables::table.empty.description', ['model' => self::$modelLabel]));
    }
}
