<?php

namespace App\Enums;

use Filament\Support\Contracts\HasLabel;

enum FuelType: int implements HasLabel
{
    case GASOLINE = 1;
    case DIESEL = 2;
    case LPG = 3;
    case ELECTRIC = 4;
    case HYBRID = 5;

    public function getLabel(): string
    {
        return match ($this) {
            self::GASOLINE => 'Benzin',
            self::DIESEL => 'Dizel',
            self::LPG => 'Benzin & LPG',
            self::ELECTRIC => 'Elektrik',
            self::HYBRID => 'Hibrit',
        };
    }
}
