<?php
session_start();

// Güvenlik: Sadece POST isteklerine yanıt ver
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit;
}

// POST ile gelen JSON verisini alıyoruz
$input = file_get_contents("php://input");

// JSON verisini çözümle
$clientData = json_decode($input, true);

// Geçerli bir JSON ve Array olup olmadığını kontrol et
if (is_array($clientData)) {

    // Veri Doğrulama ve Temizleme (Sanitization)
    // status - boolean veya belirli değerler olmalı
    $status = isset($clientData['status']) ? (bool)$clientData['status'] : false;

    // first_name - String, HTML taglerinden arındırılmış
    $first_name = isset($clientData['first_name']) ? strip_tags(trim($clientData['first_name'])) : '';

    // last_name - String, HTML taglerinden arındırılmış
    $last_name = isset($clientData['last_name']) ? strip_tags(trim($clientData['last_name'])) : '';

    // Session'a kaydet (Strict Typing yaparak)
    $_SESSION['client'] = [
        'status' => $status,
        'first_name' => htmlspecialchars($first_name, ENT_QUOTES, 'UTF-8'),
        'last_name' => htmlspecialchars($last_name, ENT_QUOTES, 'UTF-8'),
    ];

    // Başarılı yanıt
    header('Content-Type: application/json');
    echo json_encode(['status' => 'success']);

} else {
    // Hatalı veri formatı
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
}
?>
