<!-- İletişim Banner -->
<section class="contact-banner position-relative d-flex align-items-center justify-content-center">
    <div class="banner-overlay position-absolute top-0 start-0 w-100 h-100"></div>
    <div class="container position-relative z-3 text-center text-white">
        <h1 class="display-3 fw-bold mb-3 text-white sal-animate" data-sal="slide-up" data-sal-duration="600" data-sal-delay="100">
            Bizimle İletişime Geçin
        </h1>
        <p style="font-size: 20px !important;" class="fs-5 mb-0 sal-animate" data-sal="slide-up" data-sal-duration="700" data-sal-delay="200">
          Müşteri memnuniyetini ön planda tutan ekibimiz, günün her saatinde size yardımcı olmaya hazırdır.<br>
Teknik veya satış desteğine ihtiyaç duyduğunuzda, profesyonel ekibimize canlı sohbet, e-posta ya da telefon üzerinden kolayca ulaşabilir, sorularınıza hızlı ve kesin çözümler bulabilirsiniz.
        </p>
    </div>
</section>

<!-- İletişim İçerik -->
<section class="contact-section py-5 py-lg-5">
    <div class="container">

        <!-- İletişim Bilgileri Kartları -->
        <div class="row g-4 mb-5">
            <div class="col-lg-4 col-md-6">
                <div class="info-card text-center p-5 h-100 sal-animate" data-sal="fade" data-sal-duration="500" data-sal-delay="100">
                    <div class="icon-wrapper mx-auto mb-4">
                        <i style="color:black;" class="fas fa-map-marker-alt"></i>
                    </div>
                    <h5 class="fw-bold mb-3 text-dark">Adresimiz</h5>
                    <p class="text-muted mb-0 lh-lg">
                        <i class="fas fa-building me-2 text-primary"></i>
                        Mevlana Mah. Issıkgöl Cad.
                        No:99 K:5 D:74
                        Gökdemir Plaza
                        <strong>Gebze / Kocaeli</strong>
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="info-card text-center p-5 h-100 sal-animate" data-sal="fade" data-sal-duration="500" data-sal-delay="200">
                    <div class="icon-wrapper mx-auto mb-4">
                        <i style="color:black;" class="fas fa-phone-alt"></i>
                    </div>
                    <h5 class="fw-bold mb-3 text-dark">Telefon</h5>
                    <div class="d-flex flex-column gap-3">
                        <a href="tel:+904448637" class="contact-link">
                            <i class="fas fa-phone-volume me-2"></i>
                            <span>444 86 37</span>
                        </a>
                        <div class="mt-2">
                            <small class="text-muted">
                                <i class="far fa-clock me-1"></i>
                                Hafta içi 09:00 - 18:00
                            </small>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="info-card text-center p-5 h-100 sal-animate" data-sal="fade" data-sal-duration="500" data-sal-delay="300">
                    <div class="icon-wrapper mx-auto mb-4">
                        <i style="color:black;" class="fas fa-envelope"></i>
                    </div>
                    <h5 class="fw-bold mb-3 text-dark">E-posta</h5>
                    <div class="d-flex flex-column gap-3">
                        <a style="text-align:center;"  href="mailto:info@serversistemleri.com" class="contact-link">
                            <i class="fas fa-paper-plane me-2"></i>
                            <span>info@serversistemleri.com</span>
                        </a>
                        <div class="mt-2">
                            <small class="text-muted">
                                <i class="fas fa-headset me-1"></i>
                                7/24 Destek
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form ve Sosyal Medya -->
        <div class="row g-4 g-lg-5">
            <!-- İletişim Formu -->
            <div class="col-lg-8">
                <div class="form-wrapper p-4 p-lg-5 sal-animate" data-sal="slide-right" data-sal-duration="600">
                    <h3 class="h4 fw-bold mb-4">Mesaj Gönderin</h3>

                    <form id="contactForm" method="post">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold mb-2">
                                    Ad Soyad <span class="text-danger">*</span>
                                </label>
                                <input type="text" name="name" placeholder="Adınız Soyadınız" class="form-control py-3" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold mb-2">
                                    E-posta <span class="text-danger">*</span>
                                </label>
                                <input type="email" name="email" placeholder="ornek@email.com" class="form-control py-3" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold mb-2">Telefon</label>
                                <input type="text" name="phone" placeholder="+90 (___) ___ __ __" class="form-control py-3">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold mb-2">Konu</label>
                                <input type="text" name="subject" placeholder="Mesaj Konusu" class="form-control py-3">
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-semibold mb-2">
                                    Mesajınız <span class="text-danger">*</span>
                                </label>
                                <textarea name="message" rows="5" placeholder="Mesajınızı buraya yazın..." class="form-control py-3" required></textarea>
                            </div>

                            <div class="col-12">
                                <button type="submit" class="btn btn-primary btn-lg px-4 py-3 w-100 w-sm-auto">
                                    <i class="fas fa-paper-plane me-2"></i>Mesajı Gönder
                                </button>
                            </div>
                        </div>

                        <div id="formResponse" class="mt-3"></div>
                    </form>
                </div>
            </div>

            <!-- Sosyal Medya -->
            <div class="col-lg-4">
                <div class="social-wrapper sal-animate" data-sal="slide-left" data-sal-duration="600">
                    <!-- Sosyal Medya Kartı -->
                    <div class="social-card p-4 mb-4">
                        <h5 class="fw-bold mb-3">
                            <i class="fas fa-share-alt me-2"></i>Sosyal Medya
                        </h5>
                        <p class="text-muted mb-4">Bizi sosyal medyada takip edin</p>

                        <div class="social-links">
                            <a href="https://www.facebook.com/serversistemleri" target="_blank" class="social-btn" title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="https://x.com/ServerSistemler" target="_blank" class="social-btn" title="X">
                                <i class="fa-brands fa-square-x-twitter"></i>
                            </a>
                            <a href="https://www.instagram.com/serversistemleri/" target="_blank" class="social-btn" title="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="https://www.linkedin.com/company/serversistemleri/posts/?feedView=all" target="_blank" class="social-btn" title="LinkedIn">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                            <a href="https://www.youtube.com/@serversistemleri705" target="_blank" class="social-btn" title="YouTube">
                                <i class="fab fa-youtube"></i>
                            </a>
                            <a href="https://wa.me/904448637" target="_blank" class="social-btn" title="WhatsApp">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Google Maps -->
        <div class="row mt-5">
            <div class="col-12">
                <div class="map-container sal-animate" data-sal="zoom-in" data-sal-duration="600">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d65563.51111919976!2d29.399500953791026!3d40.801595823146535!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14cadfb45ccda23b%3A0xaced93af16c13955!2sUnna%20Bili%C5%9Fim%20San.%20Tic.%20A.%C5%9E.!5e1!3m2!1str!2sde!4v1762968585423!5m2!1str!2sde"
                            width="100%"
                            height="400"
                            style="border:0;"
                            allowfullscreen=""
                            loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<!-- CSS -->
<style>
/* Banner */
.contact-banner {
    min-height: 400px;
    background: url('https://serversistemleri.com/assets/img/contact-banner.webp') center center/cover no-repeat;

    position: relative;
}

.banner-overlay {
    background: linear-gradient(135deg, rgb(0 0 0) 0%, rgb(118 75 162 / 80%) 100%);
    backdrop-filter: blur(2px);
}

.contact-banner h6,
.contact-banner h1,
.contact-banner p {
    text-shadow: 0 2px 10px rgba(0,0,0,0.3);
}

/* İletişim Kartları */
.info-card {
    background: #fff;
    border-radius: 16px;
    border: 2px solid #f0f0f0;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.info-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    transform: scaleX(0);
    transition: transform 0.4s ease;
}

.info-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 40px rgba(102, 126, 234, 0.15);
    border-color: #667eea;
}

.info-card:hover::before {
    transform: scaleX(1);
}

.info-card .icon-wrapper {
    width: 70px;
    height: 70px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 16px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
    transition: all 0.4s ease;
}

.info-card:hover .icon-wrapper {
    transform: scale(1.1) rotate(5deg);
    box-shadow: 0 12px 30px rgba(102, 126, 234, 0.4);
}

.info-card .icon-wrapper i {
    font-size: 28px;
    color: #fff;
}

.contact-link {
    align-items: center;
    text-decoration: none;
    color: #2c3e50;
    font-weight: 600;
    font-size: 16px;
    padding: 10px 20px;
    border-radius: 10px;
    background: #f8f9fa;
    transition: all 0.3s ease;
}

.contact-link:hover {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff !important;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
}

.contact-link i {
    font-size: 14px;
    transition: transform 0.3s ease;
}

.contact-link:hover i {
    transform: scale(1.2);
}

/* Form */
.form-wrapper {
    background: #fff;
    border-radius: 12px;
    border: 1px solid #e9ecef;
}

.form-control {
    border: 1px solid #dee2e6;
    border-radius: 8px;
}

.form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}

/* Sosyal Medya */
.social-card {
    background: #fff;
    border-radius: 12px;
    border: 1px solid #e9ecef;
}

.social-links {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
}

.social-btn {
    width: 45px;
    height: 45px;
    background: #f8f9fa;
    border-radius: 8px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    color: #495057;
    transition: all 0.3s ease;
}

.social-btn:hover {
    background: #667eea;
    color: #fff;
    transform: translateY(-3px);
}

.social-btn i {
    font-size: 18px;
}

/* Buton */
.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
}

/* Harita */
.map-container {
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0,0,0,0.08);
}

/* Responsive */
@media (max-width: 991px) {
    .contact-banner {
        min-height: 350px;
    }

    .social-links {
        justify-content: center;
    }
}

@media (max-width: 767px) {
    .contact-banner {
        min-height: 300px;
        background-attachment: scroll;
    }

    .contact-banner h1 {
        font-size: 2rem;
    }

    .info-card {
        margin-bottom: 0;
    }

    .info-card .icon-wrapper {
        width: 60px;
        height: 60px;
    }

    .info-card .icon-wrapper i {
        font-size: 24px;
    }

    .contact-link {
        font-size: 14px;
        padding: 8px 16px;
    }

    .form-wrapper {
        padding: 1.5rem !important;
    }

    .social-card {
        text-align: center;
    }

    .map-container iframe {
        height: 300px;
    }
}

@media (max-width: 575px) {
    .contact-banner {
        min-height: 250px;
    }

    .contact-banner h1 {
        font-size: 1.75rem;
    }

    .btn-lg {
        width: 100%;
    }
}
</style>

<!-- jQuery ve AJAX -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    // Telefon formatı
    $('input[name="phone"]').on('input', function() {
        let value = $(this).val().replace(/\D/g, '');
        if (value.length > 0) {
            let formatted = '+90 ';
            if (value.length > 2) {
                formatted += '(' + value.substring(2, 5);
                if (value.length > 5) {
                    formatted += ') ' + value.substring(5, 8);
                    if (value.length > 8) {
                        formatted += ' ' + value.substring(8, 10);
                        if (value.length > 10) {
                            formatted += ' ' + value.substring(10, 12);
                        }
                    }
                }
            }
            $(this).val(formatted);
        }
    });

    // Form gönderimi
    $('#contactForm').on('submit', function (e) {
        e.preventDefault();

        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();

        submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Gönderiliyor...');

        $.ajax({
            url: 'https://serversistemleri.com/require/pages/inc/mail/mailsend.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    $('#formResponse').html('<div class="alert alert-success"><i class="fas fa-check-circle me-2"></i>' + response.message + '</div>');
                    $('#contactForm')[0].reset();
                } else {
                    $('#formResponse').html('<div class="alert alert-danger"><i class="fas fa-exclamation-circle me-2"></i>' + response.message + '</div>');
                }
            },
            error: function () {
                $('#formResponse').html('<div class="alert alert-danger"><i class="fas fa-exclamation-triangle me-2"></i>Bir hata oluştu. Lütfen tekrar deneyin.</div>');
            },
            complete: function() {
                submitBtn.prop('disabled', false).html(originalText);
            }
        });
    });
});
</script>
