<div class="pt-10">
    <div class="pb-60">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8 col-xl-6">
                    <div class="text-center pb-40 sal-animate" data-sal="slide-up" data-sal-duration="1000" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                        <h2 class="mb-0">
                            Domain Transferi
                        </h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card border-0 rounded-4 sal-animate" data-sal="fade" data-sal-duration="1500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                        <div class="card-body pt-60 pb-60 px-md-12">
                            <div class="row justify-content-center">
                                <div class="col-md-6 col-xl-6" style="display: flex; align-items: center; justify-content: center;">
                                    <form method="post">
                                        <div class="row g-4">
                                            <div class="col-6">
                                                <label for="domainName" class="form-label fs-14">
                                                    Domain Adı
                                                </label>
                                                <input value="<?php echo $_GET['domain']; ?>" name="domain" type="text" class="form-control" id="domainName" placeholder="domain.com" />

                                            </div>
                                            <div class="col-6">
                                                <label for="authCode" class="form-label fs-14">
                                                    Transfer Kodu
                                                </label>
                                                <input name="code" type="text" class="form-control" id="authCode" placeholder="Transfer Kodu" />

                                            </div>
                                            <div id="wwwWarning" style="color: red; font-size: 13px; margin-top: 5px; display: none;">
                                              Lütfen <strong>www.</strong> kullanmadan domain adresinizi yazın.
                                            </div>
                                            <span class="d-block fs-14 mt-4 fw-medium">
                                                <span class="form-text text-muted small"> <i class="fa fa-lock text-danger"></i> Bu kod mevcut alan adı firmanız tarafından güvenlik için verilmektedir. </span>
                                            </span>
                                            <div class="col-12">
                                                <a
                                                    onclick="javascript:transferAddCart();"
                                                    class="btn btn-primary btn-arrow btn-arrow-md btn-lg fs-14 fw-medium rounded col-12"
                                                    style="background-color: #455cc7; font-size: 16px; font-weight: 600 !important; padding: 4px 12px; text-align: center;"
                                                >
                                                    <span class="btn-arrow__text">
                                                        <i class="fa-solid fa-arrow-right-arrow-left" style="margin-right: 10px;"></i> Transferi Başlat
                                                        <span class="btn-arrow__icon">
                                                            <i class="las la-arrow-right"></i>
                                                        </span>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6 col-xl-6" style="display: flex; align-items: center; justify-content: center;">
                                  <div class="">
                                      <div class="container">
                                          <div class="row">
                                              <div class="col-12 sal-animate" data-sal="fade" data-sal-duration="1500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                                                  <div class="card rounded-3">
                                                      <div class="card-body p-md-6 p-xl-10">
                                                          <div class="tab-content pb-40">
                                                              <div class="tab-pane fade show active" id="validDomain" role="tabpanel">
                                                                  <div class="row g-4 align-items-center">
                                                                      <div class="col-md-12">
                                                                          <span class="badge fw-medium text-bg-primary">
                                                                              Adım 1
                                                                          </span>
                                                                          <h5 class="mt-3 mb-4">
                                                                              Transfer Öncesi Hazırlık
                                                                          </h5>
                                                                          <p class="mb-8">Mevcut sağlayıcınızdan transfer kodunu temin edin. Alan adı transfer kilidini ve WHOIS gizliliğini devre dışı bırakın.</p>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                              <div class="tab-pane fade" id="unlockedDomain" role="tabpanel">
                                                                  <div class="row g-4 align-items-center">
                                                                      <div class="col-md-12">
                                                                          <span class="badge fw-medium text-bg-primary">
                                                                              Adım 2
                                                                          </span>
                                                                          <h5 class="mt-3 mb-4">
                                                                              Transfer İşlemini Başlatma
                                                                          </h5>
                                                                          <p class="mb-8">
                                                                              Transfer etmek istediğiniz alan adını, transfer kodu ile birlikte girerek süreci başlatın.
                                                                          </p>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                              <div class="tab-pane fade" id="actNow" role="tabpanel">
                                                                  <div class="row g-4 align-items-center">
                                                                      <div class="col-md-12">
                                                                          <span class="badge fw-medium text-bg-primary">
                                                                              Adım 3
                                                                          </span>
                                                                          <h5 class="mt-3 mb-4">
                                                                              Transfer Onayı Verme
                                                                          </h5>
                                                                          <p class="mb-8">Alan adınıza ait iletişim bilgilerinde bulunan e-posta adresine gelen transfer onay e-postasını kontrol edin ve onaylayın.</p>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                              <div class="tab-pane fade" id="optionDomain" role="tabpanel">
                                                                  <div class="row g-4 align-items-center">
                                                                      <div class="col-md-12">
                                                                          <span class="badge fw-medium text-bg-primary">
                                                                              Adım 4
                                                                          </span>
                                                                          <h5 class="mt-3 mb-4">
                                                                              Transferin Tamamlandığı
                                                                          </h5>
                                                                          <p class="mb-8">Alan adınızın ServerSistemleri'ne transferi en geç 7 (yedi) gün içerisinde başarıyla tamamlanacaktır.</p>
                                                                      </div>
                                                                  </div>
                                                              </div>
                                                          </div>

                                                          <ul class="nav nav-pills nav-tab-list justify-content-center" role="tablist">
                                                              <li class="nav-item" role="presentation">
                                                                  <button class="nav-tab__btn nav-link active" data-bs-toggle="pill" data-bs-target="#validDomain" type="button" aria-selected="true" role="tab">
                                                                      <span class="d-flex align-items-center gap-1">
                                                                          <span class="nav-tab__line flex-shrink-0"></span>
                                                                          <span class="d-inline-block fw-medium fs-14 text-primary nav-tab__subtitle">01</span>
                                                                      </span>
                                                                      <span class="nav-tab__title d-block fw-semibold h6 fs-14 mb-0">
                                                                          Transfer Öncesi
                                                                      </span>
                                                                  </button>
                                                              </li>
                                                              <li class="nav-item" role="presentation">
                                                                  <button class="nav-tab__btn nav-link" data-bs-toggle="pill" data-bs-target="#unlockedDomain" type="button" aria-selected="false" tabindex="-1" role="tab">
                                                                      <span class="d-flex align-items-center gap-1">
                                                                          <span class="nav-tab__line flex-shrink-0"></span>
                                                                          <span class="d-inline-block fw-medium fs-14 text-primary nav-tab__subtitle">02</span>
                                                                      </span>
                                                                      <span class="nav-tab__title d-block fw-semibold h6 fs-14 mb-0">
                                                                          Transferi Başlat
                                                                      </span>
                                                                  </button>
                                                              </li>
                                                              <li class="nav-item" role="presentation">
                                                                  <button class="nav-tab__btn nav-link" data-bs-toggle="pill" data-bs-target="#actNow" type="button" aria-selected="false" tabindex="-1" role="tab">
                                                                      <span class="d-flex align-items-center gap-1">
                                                                          <span class="nav-tab__line flex-shrink-0"></span>
                                                                          <span class="d-inline-block fw-medium fs-14 text-primary nav-tab__subtitle">03</span>
                                                                      </span>
                                                                      <span class="nav-tab__title d-block fw-semibold h6 fs-14 mb-0">
                                                                          Transferi Onayla
                                                                      </span>
                                                                  </button>
                                                              </li>
                                                              <li class="nav-item" role="presentation">
                                                                  <button class="nav-tab__btn nav-link" data-bs-toggle="pill" data-bs-target="#optionDomain" type="button" aria-selected="false" tabindex="-1" role="tab">
                                                                      <span class="d-flex align-items-center gap-1">
                                                                          <span class="nav-tab__line flex-shrink-0"></span>
                                                                          <span class="d-inline-block fw-medium fs-14 text-primary nav-tab__subtitle">04</span>
                                                                      </span>
                                                                      <span class="nav-tab__title d-block fw-semibold h6 fs-14 mb-0">
                                                                          Transer Başarılı
                                                                      </span>
                                                                  </button>
                                                              </li>
                                                          </ul>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const domainInput = document.getElementById('domainName');
        const warningDiv = document.getElementById('wwwWarning');

        domainInput.addEventListener('input', function () {
            let value = domainInput.value.trim();

            if (value.toLowerCase().startsWith('www.')) {
                // www. varsa temizle ve uyarıyı göster
                domainInput.value = value.substring(4);
                warningDiv.style.display = 'block';
            } else {
                // www. yoksa uyarıyı gizle
                warningDiv.style.display = 'none';
            }
        });
    });
</script>
<div class="pt-60 pb-60 bg-primary bg-opacity-5">
    <div class="pb-60">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-lg-12">
                    <h2 class="sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                        Domain Avantajları
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row g-4">
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-eye-blocked" style="font-size: 46px; color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz Whois Gizleme
                            </h6>
                        </div>
                        <p class="mb-0">
                            Alan adınızın kimlik bilgilerini ücretsiz olarak saklayabilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-language" style="font-size: 46px; color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz DNS Yönetimi
                            </h6>
                        </div>
                        <p class="mb-0">
                            A Kaydı, Name Server Kaydı, MX Kaydı gibi işlemleri ücretsiz yapabilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-transfer" style="font-size: 46px; color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz Yönlendirme
                            </h6>
                        </div>
                        <p class="mb-0">
                            Domain adresinizi farklı bir domain adresine ücretsiz yönlendirebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-locked" style="font-size: 46px; color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz Domain Kilidi
                            </h6>
                        </div>
                        <p class="mb-0">
                            Alan adınızı olası izinsiz transferlere karşı ücretsiz kilitleyebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-expand2" style="font-size: 46px; color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Ücretsiz İç Transfer
                            </h6>
                        </div>
                        <p class="mb-0">
                            Alan adınızı firmamızda bulunan farklı bir hesaba ücretsiz transfer edebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                <div class="card">
                    <div class="card-body p-xl-8">
                        <div class="hstack gap-3 mb-4">
                            <span class="d-inline-block flex-shrink-0">
                                <i class="icon-cogs" style="font-size: 46px; color: #455cc7;"></i>
                            </span>
                            <h6 class="mb-0 flex-grow-1">
                                Domain Yönetimi
                            </h6>
                        </div>
                        <p class="mb-0">
                            Tüm alan adlarınızı SS-Panel'den kolayca yönetebilirsiniz.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
$faq = [
    [
        "question" => "Domain Transferi Nedir?",
        "answer" => "Bir alan adı kaydının tescil edildiği firmadan alınıp başka bir firmaya aktarılması veya aynı firmadaki farklı müşteriye aktarılmasına domain transferi denir."
    ],
    [
        "question" => "İç domain transferi nasıl yapılır?",
        "answer" => "Müşteri panelinize giriş yaparak Alan adı Yönetimi > aktif alan adlarınız bölümüne tıklayınız. İlgili alan adınızı seçtikten sonra yönet butonuna açılan sayfadan ise başka müşteriye transfer butonuna tıklayarak alıcı müşterimizin müşteri kodunu ve kendi TC kimlik numaranızı girerek transfer işlemini başlatabilirsiniz. Bu işlemi yaptıktan sonra e-posta adresinize gelecek olan onay mailine onay vermeniz gerekmektedir. Son olarak alıcı müşterimiz müşteri paneline giriş sağlayarak ana sayfadan transfer hizmetleri bölümünden transferi kabul edip işlemi tamamlamalıdır."
    ],
    [
        "question" => "Evraksız domainlerin transferi nasıl yapılır?",
        "answer" => "Talebiniz ile ilgili olarak alan adınızın transfer kodunu temin ederek, domain transfer talebinde bulunabilirsiniz. Domain transferiniz 5 - 7 gün içinde sonuçlanacaktır."
    ],
    [
        "question" => "Domain transferi için ücret alınıyor mu?",
        "answer" => "Domain transfer ücreti bulunmamaktadır. 1 yıl otomatik süre uzatma işlemi sağlandığı için yenileme ücreti talep edilmektedir."
    ],
    [
        "question" => "Evraksız domainlerin transferi kaç günde sonuçlanır?",
        "answer" => "5-7 gün içinde sonuçlanır."
    ],
    [
        "question" => "Evraklı domainlerin transferi kaç günde sonuçlanır?",
        "answer" => "2 iş günü içinde sonuçlanır."
    ],
    [
        "question" => "İç transfer kaç günde sonuçlanır?",
        "answer" => "Transfere onay verilmesi durumunda aynı gün transfer edilir."
    ],
    [
        "question" => "Alan adımın ServerSistemleri tarafına transferini başlattım. Transfer sürecini nasıl takip edebilirim?",
        "answer" => "ServerSistemleri kurumuna başlatılan transferleri, alan adı yönetimi altında bulunan bekleyen alan adları sekmesine gelerek takip edebilirsiniz. Bu ekranda alan adı transfer detaylarının sunulduğu bölüm mevcuttur."
    ],
    [
        "question" => "Satın Alınan Alan Adı Farklı Bir Kaydediciye Transfer Edilebilir Mi?",
        "answer" => "İkinci el alan adı platformu üzerinden satın alınan alan adları için ilk 45 gün boyunca EPP kodu (Transfer Kodu) alınamaz ve bu süre içerisinde farklı bir alan adı kaydedicisine transfer edilemez."
    ],
    [
        "question" => "Alan Adımın Transfer Koduna Nasıl Ulaşabilirim?",
        "answer" => "ServerSistemleri.com adresindeki müşteri panelinizdeki alan adı yönetimi altındaki alan adınızı seçip detaylara tıklayınız. Alan adı detaylarında bulunan Transfer sekmesinden Transfer Et butonunu tıklayıp, TC Kimlik numaranızı girerseniz, formu gönder demeniz ile beraber üye bilgilerine kayıtlı bulunan mail adresine transfer kodu gönderilmiş olacaktır."
    ],
    [
        "question" => "Domain İç transferde ücret alınıyor mu?",
        "answer" => "Domain iç transferinde ücret alınmamaktadır."
    ]
];

 ?>
 <div class="pt-60 pb-120">
   <div class="pb-40">
       <div class="container">
           <div class="row justify-content-center">
               <div class="col-md-10 col-lg-8 col-xl-7">
                   <div class="text-center sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                       <h2>
                           Sıkça Sorulan Sorular
                       </h2>
                   </div>
               </div>
           </div>
       </div>
   </div>
   <div class="container">
       <div class="row g-4 justify-content-center">
           <div class="col-12">
               <?php $faq_sira = 0; ?>
               <div class="accordion border-0 vps-hosting-accordion" id="accordionFaq2">
                 <div class="row">
                   <?php foreach ($faq as $key): ?>
                       <?php $faq_sira = $faq_sira + 1; ?>
                     <div class="col-sm-6">
                       <div class="accordion-item border rounded-3 mb-4 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
                           <h2 class="accordion-header">
                               <button class="accordion-button bg-transparent collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-<?php echo $faq_sira; ?>" aria-expanded="false" aria-controls="faq-<?php echo $faq_sira; ?>">
                                   <span class="text-body fs-16 fw-bold"><?php echo $key['question']; ?></span>
                               </button>
                           </h2>
                           <div id="faq-<?php echo $faq_sira; ?>" class="accordion-collapse collapse" data-bs-parent="#faq-<?php echo $faq_sira; ?>" style="">
                               <div class="accordion-body pt-0">
                                   <?php echo $key['answer']; ?>
                               </div>
                           </div>
                       </div>
                     </div>
                   <?php endforeach; ?>
                 </div>
               </div>
           </div>
       </div>
   </div>
</div>
<script type="text/javascript">
function transferAddCart() {
  const domain = document.getElementById('domainName').value;
  const authCode = document.getElementById('authCode').value;

  if (!domain || !authCode) {
      alert('Lütfen domain adı ve transfer kodunu giriniz.');
      return;
  }

  const product = {
      productId: generateUUID(), // Rastgele UUID oluşturulur
      domain: domain,
      action: "transfer", // Transfer işlemi
      itemName: "Domain Transferi", // Ürün adı
      type: "domain", // Ürün türü
      price: 0, // Transfer için fiyat (eğer varsa burada belirtilir)
      pers: { transferkodu: authCode }

  };

  // Sepete ekleme işlemi
  addToCart(product);

  // Sepeti sunucuya gönderme işlemi
  sendCartToServer(product, document.querySelector('.btn-primary'));
}

// Sepete ürün ekle
function addToCart(product) {
  let cart = JSON.parse(localStorage.getItem('cart')) || [];

  // Ürünü sepete ekliyoruz
  cart.push(product);

  // Sepeti tekrar LocalStorage'a kaydet
  localStorage.setItem('cart', JSON.stringify(cart));

  console.log('Ürün sepete eklendi:', product);
}

// Sepeti sunucuya gönderme fonksiyonu
function sendCartToServer(product, element) {
  fetch('/require/pages/add-to-cart.php', {
      method: 'POST',
      headers: {
          'Content-Type': 'application/json'
      },
      body: JSON.stringify([product]) // Sepet verisini JSON formatında gönderiyoruz
  })
  .then(response => {
      if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
      }
      return response.json();
  })
  .then(data => {
      if (data.status === 'success') {
          console.log('Sepet sunucuya başarıyla kaydedildi:', data.cart);
          element.href = './sepet';
          element.onclick = '';
          element.innerHTML = '<span class="fa-solid fa-basket-shopping"></span> Ödeme Yap';
      } else {
          console.error('Sepet kaydedilemedi:', data.message);
      }
  })
  .catch(error => {
      console.error('Sunucuya gönderim sırasında bir hata oluştu:', error);
      element.innerHTML = 'Hata oluştu. Tekrar deneyiniz.';
  });
}

// Rastgele UUID üretmek için basit bir fonksiyon
function generateUUID() {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
      var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
      return v.toString(16);
  });
}
</script>
