<?php
//print_r($invoice);
$status = $invoice['status'];
if ($status == 'Unpaid') {
    $currencies = $payment['currencies']['currency'];
    $codes = array_column($currencies, 'code');
    $index = array_search('TRY', $codes);
    $tryRate = $currencies[$index]['rate'];
    $merchant_id    = '128329';
    $merchant_key   = 'dPqKXp7YwAnoLPaq';
    $merchant_salt  = '5tCJ79BaxJooZkgQ';
    $email = $client['email'];
    $fiyatlandirma = $invoice['total'] * $tryRate;
    $hesap =  $fiyatlandirma * 100;
    $son = number_format($hesap, 2, '.', '');
    $payment_amount = (int)$son;
    $merchant_oid = 'SP'.$invoice['invoiceid'].'WHMCS'.time();
    $user_name = $client['fullname'];
    $user_address = $client['address1'] . ' ' . $client['city'] . ' ' . $client['state'] . ' ' . $client['country'];
    $user_phone = $client['phonenumber'];
    $merchant_ok_url = "https://sspanel.serversistemleri.com/invoices/view/" . $invoice['invoiceid'];
    $merchant_fail_url = "https://sspanel.serversistemleri.com/invoices/view/" . $invoice['invoiceid'];
    $items = $invoice['items']['item'];

    $formattedItems = [];
    foreach ($items as $item) {
      $formattedItems[] = [
          $item['description'],
          $item['amount'],
          1
        ];
      }
      $jsonData = json_encode($formattedItems);
      $encodedData = base64_encode($jsonData);
    $user_basket = $encodedData;
    if( isset( $_SERVER["HTTP_CLIENT_IP"] ) ) {
        $ip = $_SERVER["HTTP_CLIENT_IP"];
    } elseif( isset( $_SERVER["HTTP_X_FORWARDED_FOR"] ) ) {
        $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
    } else {
        $ip = $_SERVER["REMOTE_ADDR"];
    }
    $user_ip=$ip;
    $timeout_limit = "30";
    $debug_on = 1;
    $test_mode = 0;
    $no_installment = 0;
    $max_installment = 0;

    $iframe_v2="1";
    $iframe_v2_dark="0";

    $currency = "TL";
    $hash_str = $merchant_id .$user_ip .$merchant_oid .$email .$payment_amount .$user_basket.$no_installment.$max_installment.$currency.$test_mode;
    $paytr_token=base64_encode(hash_hmac('sha256',$hash_str.$merchant_salt,$merchant_key,true));
    $post_vals=array(
            'merchant_id'=>$merchant_id,
            'user_ip'=>$user_ip,
            'merchant_oid'=>$merchant_oid,
            'email'=>$email,
            'payment_amount'=>$payment_amount,
            'paytr_token'=>$paytr_token,
            'user_basket'=>$user_basket,
            'debug_on'=>$debug_on,
            'no_installment'=>$no_installment,
            'max_installment'=>$max_installment,
            'user_name'=>$user_name,
            'user_address'=>$user_address,
            'user_phone'=>$user_phone,
            'merchant_ok_url'=>$merchant_ok_url,
            'merchant_fail_url'=>$merchant_fail_url,
            'timeout_limit'=>$timeout_limit,
            'currency'=>$currency,
            'test_mode'=>$test_mode,
            'iframe_v2'=>$iframe_v2,
            'iframe_v2_dark'=> $iframe_v2_dark
        );

    $ch=curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://www.paytr.com/odeme/api/get-token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1) ;
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_vals);
    curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);

    $result = @curl_exec($ch);

    if(curl_errno($ch))
        die("PAYTR IFRAME connection error. err:".curl_error($ch));

    curl_close($ch);

    $result=json_decode($result,1);

    if($result['status']=='success')
        $token=$result['token'];
    else
    die("PAYTR IFRAME failed. reason:".$result['reason']);
}
    ?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proforma Fatura - <?php echo e($invoice['invoiceid']); ?></title>

    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#1891c5',
                        'bg-primary': '#1891c5',
                        light: '#f8f9fa'
                    }
                }
            }
        }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="icon" href="https://serversistemleri.com/assets/img/favicon-96x96.png" />
    <link rel="apple-touch-icon" sizes="57x57" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="https://serversistemleri.com/design/images/icons/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="https://serversistemleri.com/design/images/icons/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="https://serversistemleri.com/design/images/icons/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="https://serversistemleri.com/design/images/icons/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="https://serversistemleri.com/design/images/icons/favicons/favicon-16x16.png">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
        }
        .hidden {
            display: none;
        }
        .bank-select {
            font-size: 14px;
            padding: 6px 12px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .payment-button {
            background-color: #1891c5;
            padding: 0.5rem 0.75rem;
            border: 2px solid;
            color: white;
            border-radius: 8px;
            font-family: sans-serif;
            font-weight: 600;
            font-size: 0.875rem;
        }
        .special-table {
            width: 100%;
            border-collapse: collapse;
        }
        .special-table td {
            text-align: right;
            padding: 8px;
        }
        .special-table .label {
            width: 100%;
        }
        .special-table .value {
            white-space: nowrap;
        }
        dialog {
            min-width: 50%;
            background: white;
            max-width: 400px;
            padding-top: 2rem;
            border-radius: 20px;
            border: 0;
            box-shadow: 0 5px 30px 0 rgb(0 0 0 / 10%);
            animation: fadeIn 1s ease both;
        }
        dialog::backdrop {
            animation: fadeIn 1s ease both;
            background: rgb(255 255 255 / 40%);
            z-index: 2;
            backdrop-filter: blur(20px);
        }
        .x {
            filter: grayscale(1);
            border: none;
            background: none;
            position: absolute;
            top: 15px;
            right: 10px;
            transition: ease filter, transform 0.3s;
            cursor: pointer;
            transform-origin: center;
        }
        .x:hover {
            filter: grayscale(0);
            transform: scale(1.1);
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .invoices_return{
          margin-bottom:10px;
        }
    </style>
</head>

<body class="bg-white text-gray-800">
    <section id="invoice" class="min-h-screen bg-gray-50">
        <div class="container mx-auto py-8 px-4" style="max-width: 1000px;">
            <!-- Header Section -->
            <a class="invoices_return w-full block text-center text-white bg-primary hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 me-2 mb-2 dark:bg-blue-600 dark:hover:bg-primary focus:outline-none dark:focus:ring-blue-800"
               href="https://sspanel.serversistemleri.com/invoices">
               Faturalarıma dön
            </a>
            <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8 bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
              <div class="flex-shrink-0">
                  <img src="https://serversistemleri.com/design/images/ServerSistemleri_Logo.svg" alt="Server Sistemleri Logo" class="w-80 h-auto">
              </div>
                <div class="mb-6 md:mb-0">
                    <h2 class="text-3xl font-bold text-primary mb-2">Proforma Fatura #<?php echo e($invoice['invoiceid']); ?></h2>
                    <div class="space-y-1 text-gray-600">
                        <p class="text-sm">
                            Fatura Tarihi:
                            <?php if (!empty($invoice['date'])): ?>
                                <?php echo date_format(date_create($invoice['date']), "d-m-Y"); ?>
                            <?php endif; ?>

                            <?php if ($status == 'Unpaid' && !empty($invoice['duedate'])): ?>
                                | Son Ödeme Tarihi: <?php echo date_format(date_create($invoice['duedate']), "d-m-Y"); ?>
                            <?php endif; ?>

                            <?php if ($status == 'Paid' && !empty($invoice['transactions']['transaction'][0]['date'])): ?>
                                | Ödenme Tarihi: <?php echo date_format(date_create($invoice['transactions']['transaction'][0]['date']), "d-m-Y H:i"); ?>
                            <?php endif; ?>
                        </p>
                        <p class="text-sm">
                            Durum:
                            <?php
                            if ($status == 'Paid') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800'>Ödendi</span>";
                            } elseif ($status == 'Unpaid') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800'>Ödenmedi</span>";
                            } elseif ($status == 'Cancelled') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800'>İptal Edildi</span>";
                            } elseif ($status == 'Refunded') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800'>İade Edildi</span>";
                            } elseif ($status == 'Collections') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-orange-100 text-orange-800'>Tahsilat Aşamasında</span>";
                            } elseif ($status == 'Draft') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800'>Taslak</span>";
                            } elseif ($status == 'Payment Pending') {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800'>Ödeme Bekliyor</span>";
                            } else {
                                echo "<span class='inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800'>Bilinmiyor</span>";
                            }
                            ?>
                        </p>
                    </div>
                </div>

            </div>

            <!-- Client & Payment Info Section -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mb-6">
                <div class="flex flex-col lg:flex-row justify-between gap-6">
                    <div class="flex-1">
                        <p class="text-primary font-semibold text-sm uppercase tracking-wide mb-2">Sayın,</p>
                        <h3 class="text-xl font-semibold text-gray-900 mb-3"><?php echo e($client['fullname']); ?></h3>
                        <div class="space-y-1 text-gray-600">
                            <?php if (!empty($client['companyname'])): ?>
                                <p class="text-sm"><?php echo e($client['companyname']); ?></p>
                            <?php endif; ?>
                            <p class="text-sm"><?php echo e($client['address1']); ?></p>
                            <p class="text-sm"><?php echo e($client['city']); ?>, <?php echo e($client['state']); ?>, <?php echo e($client['country']); ?></p>
                        </div>
                    </div>

                    <?php if ($status == 'Unpaid'): ?>
                    <div class="lg:w-64">
                        <p class="text-primary font-semibold text-sm uppercase tracking-wide mb-3">Ödeme Yöntemi</p>
                        <select class="w-full bank-select" name="bank-select" id="bank-select">
                            <option value="kredi-karti" <?php if ($invoice['paymentmethod'] == 'paytr'): ?>selected<?php endif; ?>>Kredi Kartı</option>
                            <option value="banka-karti" <?php if ($invoice['paymentmethod'] == 'banktransfer'): ?>selected<?php endif; ?>>Banka Transferi</option>
                        </select>
                        <div id="odeme-button" class="hidden mt-3">
                            <button class="w-full payment-button" onclick="window.dialog.showModal();">ÖDEME YAP</button>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Items Table -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
                <div class="px-6 py-4 bg-primary">
                    <h3 class="text-lg font-semibold text-white">Fatura Detayları</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ürün Detayları</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Tutar</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $sayac = 0; ?>
                            <?php foreach ($invoice['items']['item'] as $item): ?>
                                <?php $sayac = $sayac + 1; ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $sayac; ?>.</td>
                                    <td class="px-6 py-4 text-sm text-gray-900"><?php echo isset($item['description']) ? nl2br($item['description']) : ''; ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 text-right">$<?php echo isset($item['amount']) ? number_format($item['amount'], 2) : ''; ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Totals Section -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mb-6">
                <div class="max-w-md ml-auto">
                    <table class="w-full">
                        <tbody class="space-y-2">
                            <tr class="flex justify-between items-center py-2">
                                <td class="text-gray-600">Ara Toplam:</td>
                                <td class="font-semibold text-gray-900">$<?php echo e($invoice['subtotal']); ?></td>
                            </tr>
                            <tr class="flex justify-between items-center py-2">
                                <td class="text-gray-600">20.00% K.D.V:</td>
                                <td class="font-semibold text-gray-900">$<?php echo e($invoice['tax']); ?></td>
                            </tr>
                            <tr class="flex justify-between items-center py-3 border-t border-gray-200">
                                <td class="text-lg font-semibold text-gray-900">Toplam:</td>
                                <td class="text-xl font-bold text-primary">$<?php echo e($invoice['total']); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Payment Transactions (if paid) -->
            <?php if ($status == 'Paid'): ?>
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden mb-6">
                <div class="px-6 py-4 bg-primary">
                    <h3 class="text-lg font-semibold text-white">Ödeme Bilgileri</h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">İşlem Tarihi</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ödeme Yöntemi</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">İşlem Numarası</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Tutar</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php if (!empty($invoice['transactions']['transaction'])): ?>
                                <?php foreach ($invoice['transactions']['transaction'] as $item): ?>
                                    <tr class="hover:bg-gray-50">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $item['date']; ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            <?php if ($item['gateway'] == 'paytr'): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">Kredi Kartı</span>
                                            <?php else: ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">Banka Transferi</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $item['transid']; ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900 text-right">$<?php echo $item['amountin']; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="px-6 py-4 text-center text-gray-500">Ödeme ile ilgili bir veri bulunamadı.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>

            <!-- Contact & Bank Info Section -->
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <!-- Contact Information -->
                    <div>
                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <svg class="w-5 h-5 text-primary mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                            </svg>
                            İletişim Bilgilerimiz
                        </h4>
                        <div class="space-y-3">
                            <div class="flex items-start">
                                <svg class="w-5 h-5 text-primary mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"></path>
                                </svg>
                                <p class="text-sm text-gray-600">Mevlana Mah. Issıkgöl Cad. No:99 K:5 D:74 Gökdemir Plaza Gebze\Kocaeli</p>
                            </div>
                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-primary mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"></path>
                                </svg>
                                <p class="text-sm text-gray-600">444 86 37</p>
                            </div>
                            <div class="flex items-center">
                                <svg class="w-5 h-5 text-primary mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"></path>
                                    <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
                                </svg>
                                <p class="text-sm text-gray-600">info@serversistemleri.com</p>
                            </div>
                        </div>
                    </div>

                    <!-- Bank Information -->
                    <div id="banka-bilgileri" class="hidden">
                        <h4 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <svg class="w-5 h-5 text-primary mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4zM18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z"></path>
                            </svg>
                            Banka Hesaplarımız
                        </h4>
                        <div class="space-y-4">
                            <div class="p-4 bg-gray-50 rounded-lg">
                                <p class="font-semibold text-sm text-gray-900 mb-2">DENIZBANK (TL)</p>
                                <p class="text-xs text-gray-600 mb-1">Hesap Sahibi: SERVER SİSTEMLERİ BİLİŞİM SAN. TİC. LTD. ŞTİ.</p>
                                <p class="text-xs text-gray-600 font-mono">IBAN: TR47 0013 4000 0228 2789 0000 01</p>
                            </div>
                            <div class="p-4 bg-gray-50 rounded-lg">
                                <p class="font-semibold text-sm text-gray-900 mb-2">DENIZBANK (USD)</p>
                                <p class="text-xs text-gray-600 mb-1">Hesap Sahibi: SERVER SİSTEMLERİ BİLİŞİM SAN. TİC. LTD. ŞTİ.</p>
                                <p class="text-xs text-gray-600 font-mono">IBAN: TR90 0013 4000 0228 2789 0000 03</p>
                            </div>
                            <div class="p-4 bg-gray-50 rounded-lg">
                                <p class="font-semibold text-sm text-gray-900 mb-2">DENIZBANK (EURO)</p>
                                <p class="text-xs text-gray-600 mb-1">Hesap Sahibi: SERVER SİSTEMLERİ BİLİŞİM SAN. TİC. LTD. ŞTİ.</p>
                                <p class="text-xs text-gray-600 font-mono">IBAN: TR63 0013 4000 0228 2789 0000 04</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bank Transfer Notice -->
                <div id="banka-bilgilendirme" class="text-center mt-6 p-4 bg-blue-50 rounded-lg border border-blue-200 hidden">
                    <p class="text-sm text-blue-800">
                        <span class="font-semibold">Bilgilendirme!</span> Lütfen Banka Transferi ile ödeme yapmak istiyorsanız açıklama kısmına
                        <span class="font-bold">Referans Numarası: <?php echo e($invoice['invoiceid']); ?></span> yazın.<br>
                        Bu sayede ödeme işleminiz çok daha hızlı şekilde gerçekleştirilebilir.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>

<?php if ($status == 'Unpaid'): ?>
  <script>
  window.addEventListener('load', function() {
    // URL parametrelerini al
    const params = new URLSearchParams(window.location.search);

    // Eğer "pmet" parametresi "paytr" ise
    if (params.get('pmet') === 'paytr') {
        // Butona tıklama işlemini gerçekleştir
        document.querySelector('.payment-button').click();
    }
});

    function updatePaymentOptions() {
      var selectedValue = document.getElementById('bank-select').value;
      var odemeButton = document.getElementById('odeme-button');
      var bankaBilgileri = document.getElementById('banka-bilgileri');
      var bankabilgilendirme = document.getElementById('banka-bilgilendirme');
      if (selectedValue === 'kredi-karti') {
        odemeButton.classList.remove('hidden');
        bankaBilgileri.classList.add('hidden');
        bankabilgilendirme.classList.add('hidden');
      } else if (selectedValue === 'banka-karti') {
        bankaBilgileri.classList.remove('hidden');
        odemeButton.classList.add('hidden');
        bankabilgilendirme.classList.remove('hidden');
      } else {
        odemeButton.classList.add('hidden');
        bankaBilgileri.classList.add('hidden');
        bankabilgilendirme.classList.add('hidden');
      }
    }

    document.getElementById('bank-select').addEventListener('change', updatePaymentOptions);

    // Sayfa yüklendiğinde seçili değeri kontrol et
    document.addEventListener('DOMContentLoaded', function() {
      updatePaymentOptions();
    });
  </script>

  <dialog id="dialog">
    <script src="https://www.paytr.com/js/iframeResizer.min.js?v2"></script>
    <iframe src="https://www.paytr.com/odeme/guvenli/<?php echo $token;?>" id="paytriframe" frameborder="0" scrolling="no" style="width: 100%; height: 100%;"></iframe>
    <script>iFrameResize({}, '#paytriframe');</script>
    <button onclick="window.dialog.close();" aria-label="close" class="x">❌</button>
  </dialog>
<?php endif; ?>
</body>

</html>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/invoices_view.blade.php ENDPATH**/ ?>