<?php $pageTitle = 'Destek Taleplerim'; ?>
<?php echo $__env->make("layouts.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style media="screen">
  .icon {width: 20px;fill:white;}
  .bg-color-blue{background-color: #3f70d1; color:white;}
</style>
<main class="fi-main mx-auto h-full w-full px-4 md:px-6 lg:px-8 max-w-screen-2xl">
    <div class="fi-page fi-dashboard-page">
        <section class="flex flex-col gap-y-8 py-8">
            <header class="fi-header flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
                <div>
                    <h1 class="fi-header-heading text-2xl font-bold tracking-tight text-gray-950 dark:text-white sm:text-3xl">
                        Destek Taleplerim
                    </h1>
                </div>
            </header>
            <div>
                <div class="grid flex-1 auto-cols-fr gap-y-8">
                    <div class="flex flex-col gap-y-6">
                        <div class="fi-ta">
                            <div class="fi-ta-ctn divide-y divide-gray-200 overflow-hidden rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:divide-white/10 dark:bg-gray-900 dark:ring-white/10">
                                <div class="fi-ta-content relative divide-y divide-gray-200 overflow-x-auto dark:divide-white/10 dark:border-t-white/10">
                                  <div class="mx-auto p-4">
                                    <div id="reply-section" class="bg-color-blue  dark:bg-gray-800 rounded-lg shadow-md p-4 mb-4 cursor-pointer">
                                        <div class="flex justify-between items-center">
                                            <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200">Yanıtla</h2>
                                            <button class="text-blue-500 hover:text-blue-700 dark:text-blue-300 dark:hover:text-blue-500">+</button>
                                        </div>
                                    </div>
                                    <form style="margin-bottom:20px;" method="POST" action="<?php echo e(route('submit-ticket')); ?>" enctype="multipart/form-data" id="reply-form" class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 mt-4 hidden">
                                      <?php echo csrf_field(); ?>
                                      <div style="display:none;" class="mb-4">
                                        <label for="ticket_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Ticket ID</label>
                                        <input type="hidden" id="ticket_id" name="ticket_id" value="<?php echo e($tickets['id']); ?>" class="mt-1 block w-full rounded-md bg-gray-100 dark:bg-gray-700 border-gray-300 dark:border-gray-600 text-gray-900 dark:text-gray-100 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                      </div>
                                      <div style="display:none;" class="mb-4">
                                        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">İsim</label>
                                        <input type="hidden" id="name" name="name" value="<?php echo e($tickets['name']); ?>" class="mt-1 block w-full rounded-md bg-gray-100 dark:bg-gray-700 border-gray-300 dark:border-gray-600 text-gray-900 dark:text-gray-100 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                      </div>
                                      <div style="display:none;" class="mb-4">
                                        <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">E-posta Adresi</label>
                                        <input type="hidden" id="email" name="email" value="<?php echo e($tickets['email']); ?>" class="mt-1 block w-full rounded-md bg-gray-100 dark:bg-gray-700 border-gray-300 dark:border-gray-600 text-gray-900 dark:text-gray-100 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                      </div>
                                      <div class="mb-4">
                                        <label for="message" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Mesaj</label>
                                        <textarea id="message" name="message" rows="4" class="mt-1 block w-full rounded-md bg-gray-100 dark:bg-gray-700 border-gray-300 dark:border-gray-600 text-gray-900 dark:text-gray-100 shadow-sm focus:ring-blue-500 focus:border-blue-500"></textarea>
                                      </div>
                                      <div class="mb-4">
                                        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white" for="user_avatar">Dosya Ekle</label>
                                        <input class="block text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" aria-describedby="user_avatar_help" id="user_avatar" name="user_avatar" type="file">
                                        <div class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="user_avatar_help">İzin verilen dosya türleri:<b> .jpg, .gif, .jpeg, .png, .txt, .pdf</b></div>
                                      </div>
                                      <div class="flex justify-end">
                                        <button style="--c-400:var(--primary-400);--c-500:var(--primary-500);--c-600:var(--primary-600);" class="fi-btn relative grid-flow-col items-center justify-center font-semibold outline-none transition duration-75 focus-visible:ring-2 rounded-lg fi-color-custom fi-btn-color-primary fi-color-primary fi-size-md fi-btn-size-md gap-1.5 px-3 py-2 text-sm inline-grid shadow-sm bg-custom-600 text-white hover:bg-custom-500 focus-visible:ring-custom-500/50 dark:bg-custom-500 dark:hover:bg-custom- 400 dark:focus-visible:ring-custom-400/50 fi-ac-action fi-ac-btn-action">Gönder</button>
                                      </div>
                                    </form>
                                      <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4">
                                          <div class="flex justify-between items-center mb-4">
                                              <div>
                                                  <div class="text-sm text-gray-500 dark:text-gray-400">Bildirim No</div>
                                                  <div class="text-lg text-gray-800 dark:text-gray-200"><?php echo e($tickets['tid']); ?></div>
                                              </div>
                                              <div>
                                                  <div class="text-sm text-gray-500 dark:text-gray-400">Başlık</div>
                                                  <div class="text-lg text-gray-800 dark:text-gray-200"><?php echo e($tickets['subject']); ?></div>
                                              </div>
                                              <div>
                                                  <div class="text-sm text-gray-500 dark:text-gray-400">Öncelik</div>
                                                  <div class="text-lg text-gray-800 dark:text-gray-200"><?php echo e($tickets['priority']); ?></div>
                                              </div>
                                              <div>
                                                  <div class="text-sm text-gray-500 dark:text-gray-400">Departman</div>
                                                  <div class="text-lg text-gray-800 dark:text-gray-200"><?php echo e($tickets['deptname']); ?></div>
                                              </div>
                                          </div>
                                          <?php $reversedReplies = array_reverse($tickets['replies']['reply']); ?>
                                          <?php foreach ($reversedReplies as $ticket): ?>
                                              <div style="padding: 10px;" class="border-t border-gray-300 dark:border-gray-600 pt-4">
                                                  <div class="text-sm text-gray-500 dark:text-gray-400"><?php echo date('d/m/Y (H:i)', strtotime($ticket['date'])); ?></div>
                                                  <div class="flex items-center mt-2">
                                                      <div class="w-8 h-8 rounded-full bg-gray-400 dark:bg-gray-600 mr-2 flex items-center justify-center" style="margin-right:10px;">
                                                          <span class="text-white font-bold"><?php echo strtoupper(substr($ticket['name'], 0, 1)); ?></span>
                                                      </div>
                                                      <div class="text-gray-800 dark:text-gray-200">
                                                          <span class="font-semibold"><?php echo htmlspecialchars($ticket['name'], ENT_QUOTES, 'UTF-8'); ?></span>
                                                          <p><?php echo nl2br(htmlspecialchars($ticket['message'], ENT_QUOTES, 'UTF-8')); ?></p>
                                                          <?php if (!empty($ticket['attachments'])): ?>
                                                              <p style="margin-top:20px;"><b>Ek Dosyalar</b></p>
                                                              <?php foreach ($ticket['attachments'] as $file): ?>
                                                                  <p><a href="<?php echo route('download.attachment', ['ticketId' => $tickets['ticketid'], 'filename' => $file['filename'], 'relatedid' => $ticket['replyid'], 'type' => 'reply']); ?>"><?php echo $file['filename']; ?></a></p>
                                                              <?php endforeach; ?>
                                                          <?php endif; ?>
                                                      </div>
                                                  </div>
                                              </div>
                                          <?php endforeach; ?>
                                      </div>
                                  </div>
                                  <script>
                                  document.getElementById('reply-section').addEventListener('click', function() {
                                    var replyForm = document.getElementById('reply-form');
                                    if (replyForm.classList.contains('hidden')) {
                                      replyForm.classList.remove('hidden');
                                    } else {
                                      replyForm.classList.add('hidden');
                                    }
                                  });
                                  </script>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</main>
<?php echo $__env->make("layouts.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/ssplus/sspanel.serversistemleri.com/resources/views/tickets_details.blade.php ENDPATH**/ ?>