<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\DatabaseController;
class WhmcsService
{
    protected $url;
    protected $identifier;
    protected $secret;
    protected $db;

    public function __construct()
    {
        $this->url = config('whmcs.url');
        $this->identifier = config('whmcs.identifier');
        $this->secret = config('whmcs.secret');
        $this->db = new DatabaseController();
    }

    protected function callApi($action, $params = [])
    {

        if (!isset($params['limitnum'])) {
            $params['limitnum'] = 100000;
        }

        $params = array_merge($params, [
            'action' => $action,
            'identifier' => $this->identifier,
            'secret' => $this->secret,
            'responsetype' => 'json',
        ]);

        $response = Http::asForm()->post($this->url, $params);
        return $response->json();
    }



    public function validateLogin($email, $password)
    {
        return $this->callApi('ValidateLogin', [
            'email' => $email,
            'password2' => $password
        ]);
    }

    public function getClientDetails($clientId)
    {
        return $this->callApi('GetClientsDetails', [
            'clientid' => $clientId
        ]);

        $this->db->addLog('getClientDetails', $clientId, "Kullanıcı Detayları çekildi.");
    }

    public function getClientDetailsMail($mailadress)
    {
        return $this->callApi('GetClientsDetails', [
            'email' => $mailadress
        ]);
    }

    public function getClientIdByAuthUserId($authUserId)
    {

    $response = $this->callApi('GetClientsDetails', [
      'auth_user_id' => $authUserId,
    ]);

    return $response;
}


public function openTicket(
    int $clientId,
    string $priority,
    string $message,
    string $subject,
    int $deptid,
    ?string $relatedService = null
) {
    // Normalize et
    $relatedService = is_string($relatedService) ? trim($relatedService) : '';

    // Seçilmemişse: servicesiz gönder
    if ($relatedService === '') {
        return $this->callApi('OpenTicket', [
            'deptid'   => $deptid,
            'subject'  => $subject,
            'message'  => $message,
            'clientid' => $clientId,
            'priority' => $priority,
            'markdown' => true,
        ]);
    }

    // "S123" → serviceid, "D456" → domainid
    if (preg_match('/^S(\d+)$/', $relatedService, $m)) {
        return $this->callApi('OpenTicket', [
            'deptid'    => $deptid,
            'subject'   => $subject,
            'message'   => $message,
            'clientid'  => $clientId,
            'priority'  => $priority,
            'serviceid' => (int)$m[1],
            'markdown'  => true,
        ]);
    }

    if (preg_match('/^D(\d+)$/', $relatedService, $m)) {
        return $this->callApi('OpenTicket', [
            'deptid'    => $deptid,
            'subject'   => $subject,
            'message'   => $message,
            'clientid'  => $clientId,
            'priority'  => $priority,
            'domainid'  => (int)$m[1],
            'markdown'  => true,
        ]);
    }

    // Beklenen formatta değilse de servicesiz gönder (failsafe)
    return $this->callApi('OpenTicket', [
        'deptid'   => $deptid,
        'subject'  => $subject,
        'message'  => $message,
        'clientid' => $clientId,
        'priority' => $priority,
        'markdown' => true,
    ]);
}

    public function GetPayMethods($clientId)
    {
        return $this->callApi('GetCurrencies', [
            'clientid' => $clientId,
        ]);
    }

    public function getClientProducts($clientId)
    {

        $products = $this->callApi('GetClientsProducts', [
            'clientid' => $clientId,
        ]);

        if (isset($products['products']['product'])) {
            foreach ($products['products']['product'] as &$product) {
                $productDetails = $this->callApi('GetProducts', ['pid' => $product['pid']]);
                $product['type'] = isset($productDetails['products']['product'][0]['type']) ? strtolower($productDetails['products']['product'][0]['type']) : 'other';
            }
        }

        return $products;
    }

    public function getClientProductsTickets($clientId)
    {

        $products = $this->callApi('GetClientsProducts', [
            'clientid' => $clientId,
        ]);

        return $products;
    }

    public function getClientDomains($clientId)
    {
        $domains = $this->callApi('GetClientsDomains', [
            'clientid' => $clientId,

        ]);

        if (isset($domains['domains']['domain'])) {
            $domainIds = array_column($domains['domains']['domain'], 'id');
        }

        return $domains;
    }

    public function getClientDomainDetails($id)
    {
        $this->db->addLog('getClientDomainDetails', $id, "Domain verisi çekildi.");
        return $this->callApi('GetClientsDomains', [
            'domainid' => $id
        ]);
    }

    public function updateClientDomainAutoRenew($domainId, $autoRenewStatus)
    {
        $this->db->addLog('updateClientDomainAutoRenew', $domainId, "updateClientDomainAutoRenew işlemi yapıldı.");
        $response = $this->callApi('UpdateClientDomain', [
            'domainid' => $domainId,
            'donotrenew' => $autoRenewStatus
        ]);

        // Debug log ekleyerek API cevabını kontrol edelim
        Log::debug("updateClientDomainAutoRenew API response", $response);

        return $response;
    }

    public function UpdateClient($clientId, $firstname, $lastname, $customfields2, $customfields3, $customfields4, $customfields5, $customfields6, $companyname, $email, $country, $postcode, $city, $state, $address1, $membertype)
        {

          if ($membertype == 3) {
            $vergidairesi = '';
            $verginumarasi = '';
            $firmaadi = '';
          }else {
            $vergidairesi = $customfields4;
            $verginumarasi = $customfields5;
            $firmaadi = $companyname;
          }

          $response = $this->callApi('UpdateClient', [
              'clientid' => $clientId,
              'firstname' => $firstname,
              'lastname' => $lastname,
              'phonenumber' => $customfields6,
              'customfields' => base64_encode(serialize(array(
              "3"=>$customfields2,
              "4"=>$customfields3,
              "5"=>$vergidairesi,
              "6"=>$verginumarasi,
              "10" => $customfields6))),
              'companyname' => $firmaadi,
              'email' => $email,
              'country' => $country,
              'postcode' => $postcode,
              'city' => $city,
              'state' => $state,
              'address1' => $address1,
              'groupid' => $membertype
          ]);
          $this->db->addLog('UpdateClient', $clientId, "Kullanıcı profilini güncelledi.");
          return $response;
        }

        public function AddClient($firstname, $lastname, $email, $password, $tckimlikno, $dogumyili, $phone){

            $response = $this->callApi('AddClient', [
                'firstname' => $firstname,
                'lastname' => $lastname,
                'email' => $email,
                'password2' => $password,
                'customfields' => base64_encode(serialize(array(
                    "3" => $tckimlikno ?? null,
                    "4" => $dogumyili ?? null,
                    "35" => $phone,
                    "42" => "on",
                ))),
                'phonenumber' => $phone,
                'country' => "TR"
            ]);
            $this->db->addLog('UpdateClient', $email, "Yeni bir kullanıcı kayıt oldu.");
            return $response;
        }

    public function getClientInvoices($clientId, $status = 'Unpaid')
    {
        $this->db->addLog('getClientInvoices', $clientId, "Kullanıcı Faturaları listeledi.");
        return $this->callApi('GetInvoices', [
            'userid' => $clientId,
            'status' => $status,
        ]);
    }

    public function getClientTickets($clientId, $limit)
    {
        $this->db->addLog('getClientTickets', $clientId, "Kullanıcı Destek Taleplerini listeledi.");
        return $this->callApi('GetTickets', [
            'clientid' => $clientId,
            'limitnum' => $limit ?? 100000,

        ]);
    }

    public function GetTicket($id){
      $this->db->addLog('GetTicket', $id, "Kullanıcı Destek Talebini listeledi.");
      return $this->callApi('GetTicket', [
        'ticketnum' => $id
      ]);
    }


        public function addTicketReply($clientId, $ticketId, $message, $attachmentPath = null)
        {
            $attachments = null;

            if ($attachmentPath) {
                // Dosya adını ve içeriğini al
                $fileName = $attachmentPath->getClientOriginalName();
                $fileContent = file_get_contents($attachmentPath->getPathname());
                $encodedFileContent = base64_encode($fileContent);

                // Dosya adını ve içeriğini JSON formatına çevir
                $attachment = [
                    [
                        'name' => $fileName,
                        'data' => $encodedFileContent
                    ]
                ];

                // JSON formatındaki veriyi tekrar base64 ile kodla
                $attachments = base64_encode(json_encode($attachment));
            }
            $this->db->addLog('GetTicket', $clientId, "Kullanıcı $ticketId numaralı destek talebine yeni bir cevap ekledi.");
            return $this->callApi('AddTicketReply', [
                'ticketid' => $ticketId,
                'message' => $message,
                'clientid' => $clientId,
                'markdown' => true,
                'attachments' => $attachments,
            ]);
        }


    public function getClientProductByDomain($domain)
    {
        return $this->callApi('GetClientsProducts', [
            'domain' => $domain,
        ]);
    }

    public function DomainRequestEPP($id)
    {
        $this->db->addLog('DomainRequestEPP', $id, "Domain adresinin transfer kodunu istedi.");
        return $this->callApi('DomainRequestEPP', [
            'domainid' => $id,
        ]);
    }

    public function getProductsDetails($id)
    {
        $this->db->addLog('getProductsDetails', $id, "Kullanıcı ürün detaylarını çekti.");
        return $this->callApi('GetProducts', [
            'pid' => $id,
        ]);
    }

    public function getDecryptedPassword($encryptedPassword)
    {
        $response = $this->callApi('DecryptPassword', [
            'password2' => $encryptedPassword,
        ]);

        return $response;
    }

    public function addCancelRequest($serviceId, $reason, $type)
    {
        $this->db->addLog('addCancelRequest', $serviceId, "$serviceId ürünü için iptal talebinde bulundu.");
        return $this->callApi('AddCancelRequest', [
            'serviceid' => $serviceId,
            'reason' => $reason,
            'type' => $type
        ]);
    }

    public function getDomainNameservers($id)
    {
        $this->db->addLog('getDomainNameservers', $id, "$id ürünü için NameServer talebinde bulundu.");
        return $this->callApi('DomainGetNameservers', [
            'domainid' => $id,
        ]);
    }

    public function getDomainWhoisInfo($id)
    {
        $this->db->addLog('getDomainWhoisInfo', $id, "$id ürünü için Whois talebinde bulundu.");
        return $this->callApi('DomainGetWhoisInfo', [
            'domainid' => $id,
        ]);
    }

    public function getDomainLockingStatus($domainId)
    {
        $this->db->addLog('getDomainLockingStatus', $domainId, "$domainId ürünü için Kilit durumunu sorguladı.");
        return $this->callApi('DomainGetLockingStatus', [
            'domainid' => $domainId
        ]);
    }

    public function updateDomainLockingStatus($domainId, $status)
    {
        $this->db->addLog('updateDomainLockingStatus', $domainId, "$domainId ürünü için Kilit durumunu $status olarak güncelledi.");
        $response = $this->callApi('DomainUpdateLockingStatus', [
            'domainid' => $domainId,
            'lockstatus' => $status
        ]);

        return $response;
    }

    public function DomainUpdateNameservers($domainId, $nameserver1, $nameserver2, $nameserver3 = null, $nameserver4 = null)
    {
        $this->db->addLog('DomainUpdateNameservers', $domainId, "$domainId ürünü için nameserver verilerini güncelledi.");
        $response = $this->callApi('DomainUpdateNameservers', [
            'domainid' => $domainId,
            'ns1' => $nameserver1,
            'ns2' => $nameserver2,
            'ns3' => $nameserver3,
            'ns4' => $nameserver4
        ]);

        return $response;
    }

    public function getServerDetails($serverId)
    {
        $this->db->addLog('getServerDetails', $serverId, "$serverId için detaylar sorgulandı.");
        return $this->callApi('GetServers', [
            'id' => $serverId,
        ]);
    }

    public function getClientInvoicesAll($clientId)
    {
        $this->db->addLog('getClientInvoicesAll', $clientId, "Tüm faturaları listeledi.");
        return $this->callApi('GetInvoices', [
            'userid' => $clientId,
            'orderby' => 'id',
            'order' => 'desc'
        ]);
    }



    public function getClientInvoicesId($id)
    {
        $this->db->addLog('getClientInvoicesId', $id, "Kullanıcının $id numaralı Fatura detayları getirildi.");
        return $this->callApi('GetInvoice', [
            'invoiceid' => $id,
        ]);
    }

    public function sendVerifyMail($clientId){
      $this->db->addLog('sendVerifyMail', $clientId, "Kullanıcının mail adresine doğrulama kodu gönderildi.");
      return $this->callApi('ResendClientVerificationEmail', [
          'clientid' => $clientId
      ]);
    }

    public function VerifyEmail($verificationcode){
        //$this->db->addLog('sendVerifyMail', $verificationcode, "Kullanıcı $verificationcode ile mail adresini doğruladı.");
        return $this->callApi('VerifyEmail', [
            'verificationcode' => $verificationcode
          ]);
        }

    public function SendMail($clientId, $customvars, $messagename){
      $this->db->addLog('SendMail', $clientId, "Kullanıcıya $messagename ile ilgili mail gönderildi.");
      return $this->callApi('SendEmail', [
        'id' => $clientId,
        'messagename' => $messagename,
        'customvars' => base64_encode(serialize($customvars))
      ]);
    }

      public function SendMailCustom($clientId, $subject, $message) {
        $this->db->addLog('SendMailCustom', $clientId, "Kullanıcıya $subject başlıklı ve $message değerinde bir mail gönderildi.");
        // WHMCS içindeki bir genel şablonu kullanın (örneğin, "General Notification")
        $messagename = "Özel Mail Bildirimi";

        // Custom değişkenleri ayarlayın
        $customvars = [
          'custom_subject' => $subject,
          'custom_message' => $message,
        ];

        return $this->callApi('SendEmail', [
          'id' => $clientId,
          'messagename' => $messagename,
          'customvars' => base64_encode(serialize($customvars))
        ]);
      }

    public function addOrder($params)
    {

        $configOptions = [];
        $customfields = [];

        if (!empty($params['configoptions1'])) {
            $configOptions[1] = is_array($params['configoptions1']) ? $params['configoptions1'][0] : $params['configoptions1'];
        }
        if (!empty($params['configoptions2'])) {
            $configOptions[2] = is_array($params['configoptions2']) ? $params['configoptions2'][0] : $params['configoptions2'];
        }
        if (!empty($params['configoptions3'])) {
            $configOptions[3] = is_array($params['configoptions3']) ? $params['configoptions3'][0] : $params['configoptions3'];
        }
        if (!empty($params['configoptions4'])) {
            $configOptions[4] = is_array($params['configoptions4']) ? $params['configoptions4'][0] : $params['configoptions4'];
        }

        if (!empty($params['license_1'])) {
            $license_name = $params['license_1'];
        }

        if (!empty($params['license_2'])) {
            $license_ip = $params['license_2'];
        }

        $banktransfer = 'banktransfer';
        // Eğer configoptions boşsa parametreye hiç eklemiyoruz
        $addOrderParams = [
            'clientid' => $params['clientid'] ?? null,
            'pid' => $params['pid'] ?? null,
            'domain' => $params['domain'] ?? null,
            'domaintype' => $params['domaintype'] ?? null,
            'regperiod' => $params['regperiod'] ?? null,
            'eppcode' => $params['eppcode'] ?? null,
            'nameserver1' => $params['nameserver1'] ?? null,
            'nameserver2' => $params['nameserver2'] ?? null,
            'paymentmethod' => $banktransfer,
            'billingcycle' => $params['billingcycle'] ?? null,
            'noinvoice' => $params['noinvoice'] ?? null,
            'noemail' => $params['noemail'] ?? null,
            'noinvoiceemail' => $params['noinvoiceemail'] ?? null,
            'clientip' => $_SERVER['REMOTE_ADDR'] ?? null,
            'skipvalidation' => true,
            'noinvoicepayment' => true,
        ];

        // Eğer configOptions boş değilse, parametrelere ekliyoruz
        if (!empty($configOptions)) {
            $addOrderParams['configoptions'] = base64_encode(serialize($configOptions));
        }

        if (!empty($license_name)) {
            $addOrderParams['customfields'] = array(base64_encode(serialize(array("58" => $license_name, "59" => $license_ip))));
        }

        // WHMCS API çağrısı
        $response = $this->callApi('AddOrder', $addOrderParams);
        $this->db->addLog('addOrder', $params['clientid'], "Kullanıcı yeni bir sipariş verdi.");
        //Log::info('WHMCS Api return: ' . $params['configoptions1']);
        return $response;
    }

    public function updateCSR($productId, $csrOutput){
      $response = $this->callApi('UpdateClientProduct', [
        'serviceid' => $productId,
        'customfields' => base64_encode(serialize(array(
            'CSR' => $csrOutput // CSR alanını güncelliyoruz
        )))
      ]);
      $this->db->addLog('updateCSR', $productId, "Kullanıcı $productId ürün için CSR kodu gönderdi.");
      return $response;
    }

    public function SendAdminEmail($title, $message){
      $response = $this->callApi('SendAdminEmail', [
        'customsubject' => $title,
        'custommessage' => $message,
      ]);
    }

    public function ResetPassword($email){

        $response = $this->callApi('ResetPassword', [
          'email' => $email
        ]);
        $this->db->addLog('updateCSR', $email, "Kullanıcı şifre sıfırlama bağlantısı gönderdi.");
        return $response;
    }

    public function gethostingapp($clientId) {
        $response = $this->callApi('gethostingapp', [
            'clientid' => $clientId
        ]);

        $this->db->addLog('gethostingapp', $clientId, "Kullanıcı hostinglerini çekti.");
        return $response;
    }

    public function getserversapp($clientId) {
        $response = $this->callApi('getserversapp', [
            'clientid' => $clientId
        ]);
        $this->db->addLog('getserversapp', $clientId, "Kullanıcı Serverlerını çekti.");
        return $response;
    }

    public function getothersapp($clientId) {
        $response = $this->callApi('getothersapp', [
            'clientid' => $clientId
        ]);
        $this->db->addLog('getothersapp', $clientId, "Kullanıcı Diğer Hizmetlerini çekti.");
        return $response;
    }

    public function getkurumsalmail($clientId) {
        $response = $this->callApi('getkurumsalmail', [
            'clientid' => $clientId
        ]);
        $this->db->addLog('getkurumsalmail', $clientId, "Kullanıcı Diğer Hizmetlerini çekti.");
        return $response;
    }

    public function getproductdetails($clientId, $id){
      $response = $this->callApi('getproductdetails', [
          'clientid' => $clientId,
          'productid' => $id
      ]);

      $this->db->addLog('getothersapp', $clientId, "Kullanıcı $id numaralı hizmetini listeledi.");
      return $response['details'][0];
    }

    public function getdashboard($clientId){
      return $this->callApi('getdashboard', [
        'clientid' => $clientId,
      ]);
    }

    public function sendrenewapi($clientId, $domain_id, $domain, $period){

      return $this->callApi('sendrenewapi', [
        'clientid' => $clientId,
        'domainid' => $domain_id,
        'domain' => $domain,
        'period' => $period
      ]);

      $this->db->addLog('sendrenewapi', $clientId, "Kullanıcı $domain isimli domain adresi için yenileme talebinde bulundu.");
    }

    public function sendrenew($clientId, $serviceid, $period){
      $this->db->addLog('sendrenew', $clientId, "Kullanıcı $serviceid numaralı ürünü için yenileme talebinde bulundu.");
      return $this->callApi('sendrenew', [
        'clientid' => $clientId,
        'serviceid' => $serviceid,
        'period' => $period
      ]);
    }

    public function ModuleCustom($action, $serviceId){

      return $this->callApi('ModuleCustom', [
        'func_name' => $action,
        'serviceid' => $serviceId
      ]);

    }

    public function createsmartermailuser($serviceId, $username, $displayname, $password, $mailboxsize){

      return $this->callApi('ModuleCustom', [
        'func_name' => 'createsmartermailuser',
        'serviceid' => $serviceId,
        'username' => $username,
        'displayname' => $displayname,
        'domainadmincheckbox' => 'off', // ya "on" ya boş bırakılır
        'authtype' => '0',
        'password' => $password,
        'resetonlogincheckbox' => 'off', // ya "on" ya boş
        'mailboxsize' => $mailboxsize ?? '1000', // MB cinsinden

      ]);
    }

    public function savechangessmartermailuser($serviceId, $selectuser, $username, $displayname, $password = '', $mailboxsize = 1000) {
        return $this->callApi('ModuleCustom', [
            'func_name'     => 'savechangessmartermailuser',
            'serviceid'     => $serviceId,
            'selectuser'    => $selectuser,
            'username'      => $selectuser,
            'displayname'   => $displayname,
            'password'      => $password, // boşsa değiştirmez zaten
            'mailboxsize'   => $mailboxsize,
        ]);
    }

    public function deletesmartermailuser($serviceId, $selectuser){
      return $this->callApi('ModuleCustom', [
        'func_name'     => 'deletesmartermailuser',
        'serviceid'     => $serviceId,
        'selectuser'    => $selectuser
      ]);
    }

}
