<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ConsoleLink extends Model
{
    protected $fillable = [
        'user_id', 'hostname', 'vm_id', 'autokey', 'start_date', 'end_date'
    ];

    public function isExpired()
    {
        return now()->greaterThan($this->end_date);
    }

    public function getConsoleUrlAttribute()
    {
        return url("/console/{$this->autokey}");
    }
}
