<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasLabel;
use Filament\Support\Colors\Color;

enum VehicleCertificateType: int implements HasLabel, HasColor
{
    case TRAFFICINSURANCE       = 1;
    case INSURANCE              = 2;
    case VEHICLEINSPECTION      = 3;
    case GREENCARD              = 4;
    case LCERTIFICATE           = 5;
    case AITMCERTIFICATE        = 6;
    case FRCCERTIFICATE         = 7;
    case RODERCERTIFICATE       = 8;
    case REGISTRATIONCARD       = 9;
    case TACHOGRAPHINSPECTION   = 10;
    case IMMCERTIFICATE         = 11;

    public function getLabel(): string
    {
        return match ($this) {
            self::TRAFFICINSURANCE      => 'Trafik Sigortası',
            self::INSURANCE             => 'Kasko Sigortası',
            self::VEHICLEINSPECTION     => 'Araç Muayenesi',
            self::GREENCARD             => 'Yeşil Kart',
            self::LCERTIFICATE          => 'L Belgesi',
            self::AITMCERTIFICATE       => 'Araç Uygunluk Belgesi',
            self::FRCCERTIFICATE        => 'FRC Belgesi',
            self::RODERCERTIFICATE      => 'Roder Belgesi',
            self::REGISTRATIONCARD      => 'Taşıt Kartı',
            self::TACHOGRAPHINSPECTION  => 'Takograf Muayenesi (TÜV)',
            self::IMMCERTIFICATE        => 'İhtiyari Mali Mesuliyet Sigortası (İMM)',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::TRAFFICINSURANCE      => Color::rgb('rgb(0, 102, 204)'),      // Medium Blue
            self::INSURANCE             => Color::rgb('rgb(0, 153, 51)'),       // Dark Green
            self::VEHICLEINSPECTION     => Color::rgb('rgb(255, 204, 0)'),      // Golden Yellow
            self::GREENCARD             => Color::rgb('rgb(102, 204, 0)'),      // Bright Green
            self::LCERTIFICATE          => Color::rgb('rgb(153, 51, 204)'),     // Medium Purple
            self::AITMCERTIFICATE       => Color::rgb('rgb(255, 128, 0)'),      // Deep Orange
            self::FRCCERTIFICATE        => Color::rgb('rgb(0, 153, 153)'),      // Dark Cyan
            self::RODERCERTIFICATE      => Color::rgb('rgb(255, 105, 180)'),    // Hot Pink
            self::REGISTRATIONCARD      => Color::rgb('rgb(75, 0, 130)'),       // Indigo
            self::TACHOGRAPHINSPECTION  => Color::rgb('rgb(0, 255, 255)'),      // Aqua
            self::IMMCERTIFICATE        => Color::rgb('rgb(255, 191, 0)'),      // Amber
        };
    }

    public function getIcon(): string
    {
        return 'heroicon-s-document-text';
    }
}
