<?php

// WHMCS API kimlik bilgileri
$api_url = "https://customer.serversistemleri.com/includes/api.php";
$api_identifier = "X0dhrkxgQIaNChaDxsR8UNaXmZTp2GbD";
$api_secret = "o44R1QTQTVJ1ElyuitGZjFNj6gXc28h8";

// JSON dosyası yolu
$json_file = 'whmcs_data.json';

// JSON dosyasını okuma fonksiyonu
function readJsonData($file) {
    if (file_exists($file)) {
        return json_decode(file_get_contents($file), true);
    }
    return null;
}

// JSON dosyasını güncelleme fonksiyonu
function updateJsonData($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

// WHMCS API'den veriyi çekme fonksiyonu
function fetchWHMCSData($api_url, $api_identifier, $api_secret, $action) {
    $postfields = array(
        'action' => $action,
        'identifier' => $api_identifier,
        'secret' => $api_secret,
        'responsetype' => 'json',
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postfields));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Eğer fnc=update parametresi gönderildiyse WHMCS API verisini güncelle
    $whmcs_data = array();

    // GetCurrencies verisini çekme
    $currencies = fetchWHMCSData($api_url, $api_identifier, $api_secret, 'GetCurrencies');
    if ($currencies['result'] == 'success') {
        $whmcs_data['currencies'] = $currencies;
    } else {
        echo "WHMCS GetCurrencies API hatası: " . $currencies['message'];
    }

    // GetTLDPricing verisini çekme
    $tldPricing = fetchWHMCSData($api_url, $api_identifier, $api_secret, 'GetTLDPricing');
    if ($tldPricing['result'] == 'success') {
        $whmcs_data['tldPricing'] = $tldPricing;
    } else {
        echo "WHMCS GetTLDPricing API hatası: " . $tldPricing['message'];
    }

    // GetProducts verisini çekme
    $products = fetchWHMCSData($api_url, $api_identifier, $api_secret, 'GetProducts');
    if ($products['result'] == 'success') {
        $whmcs_data['products'] = $products;
    } else {
        echo "WHMCS GetProducts API hatası: " . $products['message'];
    }

    if (!empty($whmcs_data)) {
        updateJsonData($json_file, $whmcs_data);
        echo "Veriler güncellendi ve JSON dosyasına kaydedildi.";
    }
?>
