<style media="screen">
  .banner {
    margin: 0;
    box-sizing: border-box;
    clear: both;
    padding-top: clamp(9rem, 5.5vw + 1rem, 15rem);
    padding-bottom: clamp(9rem, 5.5vw + 1rem, 15rem);
  }
  .domain-card {
    cursor: pointer;
    transition: all 0.3s ease-in-out;
    margin-bottom: 20px;
    border-radius: 10px;
    background-color: #eff1fa;
  }
  .domain-card input {
    height: 60px !important;
    border-radius: 6px;
    font-size: 22px;
  }
  .domain-card button {
    font-size: 18px;
    font-weight: 700;
    cursor: pointer;
    color: #fff;
    text-transform: uppercase;
  }
  .domain-card.active {
    background-color: #e3f7e7;
    box-shadow: 0 2px 15px rgba(0, 200, 0, 0.2);
  }
  .icon {
    width: 50px;
    height: 50px;
    margin-right: 20px;
  }
  .input-group {
    margin-top: 10px;
  }
  .domain-card .search-box {
    display: none;
  }
  .domain-card.active .search-box {
    display: flex;
  }
  .domain-title {
    font-size: 16px;
  }
  @media only screen and (max-width: 768px) {
    .search-dm-icon {
      display: none;
    }
  }
  .search-dm-icon {
    font-size: 70px;
    margin-right: 15px;
  }
</style>

<section class="banner bg-dark premium-network">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-xxl-12 col-xl-8">
        <div class="text-center">
          <h1 class="text-white mb-3 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            Web siteniz için alan adı seçin
          </h1>
          <p class="text-white mb-0 max-text-60 mx-auto text-opacity-75 sal-animate" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
            Kullanmak istediğiniz alan adını belirlemeye hazır mısınız?
          </p>
        </div>
      </div>
    </div>
  </div>
</section>
<style media="screen">
/* Genel link stilleri */
.custom-link {
    color: #fff;
    text-decoration: none;
    margin: 0 6px;
    padding: 5px 7px;
    border-radius: 5px;
    background-color: rgba(255, 255, 255, 0.1);
    transition: background-color 0.3s ease, color 0.3s ease;
    display: inline-block;
}

.custom-link:hover {
    background-color: #fff;
    color: #000;
}

/* Mobilde linklerin gizlenmesi */
@media (max-width: 768px) {
    .links {
        display: none; /* Linkleri gizle */
    }
    .domain-submit-box {
        top: 100%;
        right: 0;
        width: 100%;
        margin-top: 2px;
    }
    .domain-submit-box .btn-primary {
        width: 100%;
    }
}
.domain-search-box {
    padding: 200px;
}
@media only screen and (max-width: 1124px) {
    .domain-search {
        border-radius: 9px 9px 0px 0px;
    }
    .domain-submit-box button {
        border-radius: 0px 0px 9px 9px;
    }
    .domain-ext {
        display: none;
    }
    .domain-search-box {
        padding: 130px;
    }
}
[class*=" ssicon-"],
[class^="ssicon-"] {
    font-size: 18px;
    margin-top: 7px;
    color: black;
}
.ozellik-alani:hover {
    background-color: #eff1fa;
    border-radius: 5px;
}
.disnone {
    display: none;
}

usd,
try {
    display: none;
}

html.TRY try {
    display: inline-block;
}

html.TRY usd {
    display: none;
}

html.USD usd {
    display: inline-block;
}

html.USD try {
    display: none;
}

.domain-whois a,
button {
    text-decoration: none;
}
/* Masaüstünde fiyat gizlensin */
.fiyat,
.kime-ait {
  display: none;
}

/* Mobilde fiyat görünsün */
@media (max-width: 768px) {
    span.price {
        font-size: 100% !important;
    }
    .domain-price-old {
        display: none !important;
    }
    .mobile-center {
        justify-content: center !important;
    }
    .domain-button {
        padding: 5px;
    }
    .whois-results .result .domain-button .whois {
        display: none !important;
    }
    .mobile-prices {
        display: none !important;
    }
    .kime-ait {
        color: #455cc7 !important;
        display: block !important;
    }
    .fiyat{
      background-color: rgba(0, 0, 0, 0) !important;
      border: 1px solid black;
      font-size: 18px;
      font-weight: 600;
    padding: 4px 12px;
    text-align: center;
        border-radius: 3px;
        display: block;
        color: black;
    }
    /*.fiyat {
        font-size: 18px;
        line-height: 32px;
        display: block;
        background-color: #4caf50;
        min-width: 118px;
        color: #fff;
        border-radius: 3px;
        font-weight: 600;
        padding: 4px 12px;
        text-align: center;
        cursor: pointer;
        text-decoration: none;
    }*/
}

register {
    color: #4caf50;
}
transfer {
    color: #455cc7;
}
dikcizgi {
    margin-right: 5px;
    margin-left: 5px;
    border-right: 1px solid black;
}

@media (min-width: 1400px) {
    .container-xxl,
    .container-xl,
    .container-lg,
    .container-md,
    .container-sm,
    .container {
        max-width: 1200px;
    }
}
.ss-section.domain-whois:not(.disnone) .domain-search-icon {
    display: none;
}

.whois-results .result {
    background-color: white !important;
}

</style>
<div class="container my-5">
  <div class="row g-3">
    <!-- Card 1 -->
    <div class="col-12">
      <div class="card domain-card p-3" id="card1">
        <div class="d-flex align-items-center">
          <i style="display:none;" class="search-dm-icon fas fa-globe"></i>
          <div class="flex-grow-1">
            <h3 class="domain-title card-title">Yeni bir alan adı kaydetmek istiyorum.</h3>
            <form id="queryDomain" action="domain-sorgulama" method="GET" data-sal="slide-up" data-sal-duration="500" data-sal-delay="300" data-sal-easing="ease-in-out-sine">
              <div class="search-box input-group">
                <input type="text" class="form-control" id="domain" name="domain" placeholder="Hayalinizdeki alan adını hemen bulun!">
                <input type="submit" class="btn btn-warning" value="Sorgula">
              </div>
            </form>
            <p class="card-text">
              <span class="fw-bold">2$</span> 'dan başlayan fiyatlarla domain kaydedin!
            </p>
            <div id="domainResults" class="mt-3">
              <section class="ss-section domain-whois disnone">
              	<div class="container">
              		<div class="row justify-content-center mb-5">
              			<div class="col-md-12 ss-animate fadeInUp ss-animated">
              				<div class="whois-results">
              					<div class="results ss-animate fadeInUp ss-animated" id="results">
              						<div class="title">Sorgulanan Domainler</div>
              					</div>
              				</div>
              			</div>
              		</div>
              	</div>
              </section>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card domain-card p-3" id="card3">
        <div class="d-flex align-items-center">
          <i style="display:none;" class="search-dm-icon fas fa-exchange-alt"></i>
          <div class="flex-grow-1">
            <h3 class="domain-title card-title">Mevcut bir alan adım var, domaini transfer etmek istiyorum.</h3>
            <div class="search-box input-group">
              <input type="text" class="form-control" id="domainTransferInput" placeholder="www.">
              <button class="btn btn-warning" onclick="transferDomain()">
                <i class="fa-solid fa-magnifying-glass"></i> TRANSFER ET
              </button>
            </div>
            <p class="card-text">Kullanmak istediğiniz alan adınızı belirtin.</p>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card domain-card p-3" id="card2">
        <div class="d-flex align-items-center">
          <i style="display:none;" class="search-dm-icon fas fa-server"></i>
          <div class="flex-grow-1">
            <h3 class="domain-title card-title">Mevcut bir alan adım var, sadece isim sunucularını (nameserver) güncellemek istiyorum.</h3>
            <div class="search-box input-group">
              <input type="text" class="form-control" id="domainUpdateInput" placeholder="www.">
              <button class="btn btn-warning" onclick="updateNameservers()">
                <i class="fa-solid fa-magnifying-glass"></i> DEVAM ET
              </button>
            </div>
            <p class="card-text">Kullanmak istediğiniz alan adınızı belirtin.</p>
          </div>
        </div>
      </div>
    </div>

    <!-- Card 3 -->

  </div>
</div>
<script>
function transferDomain() {
    const domain = document.getElementById("domainTransferInput").value;

    if (!domain) {
        alert("Lütfen transfer edilecek domain adresini girin!");
        return;
    }

    // Transfer edilen domaini sepete ekle
    addToCart(domain, "transfer");
}

function updateNameservers() {
  const domain = document.getElementById('domainUpdateInput').value;

  if (!domain) {
    alert('Lütfen domain adresini girin!');
    return;
  }

  // Sadece hosting sepete eklenir, domain değil
  addToCart(domain, "updateNameserver");
}

function addToCart(domain, action, button) {
    // Ürüne göre itemName ve type belirleniyor
    let itemName = "Unknown Item";
    let type = "product";

    if (action === "registration") {
        itemName = "Domain Kaydı";
        type = "domain";
    } else if (action === "transfer") {
        itemName = "Domain Transferi";
        type = "domain";
    } else if (action === "hosting") {
        itemName = "Hosting Hizmeti";
        type = "hosting";
    }

    const cart = [];

    // Eğer işlem "registration" veya "transfer" ise domain ekle
    if (action === "registration" || action === "transfer") {
        const cartItem = {
            productId: uuid(), // Ürün için benzersiz bir ID oluşturuluyor
            domain: domain, // Domain adı
            action: action, // İşlem türü (registration, transfer)
            itemName: itemName, // Ürün ismi (Domain Kaydı, Hosting Hizmeti vs.)
            type: type, // Ürün tipi (domain)
            pers: [] // Ek bilgiler, istenirse doldurulabilir
        };
        cart.push(cartItem);
    }

    // Hosting hizmeti ekleme (updateNameserver, registration, veya transfer durumlarında)
    if (action === "updateNameserver" || action === "registration" || action === "transfer") {
        const platformId = localStorage.getItem("selectedPlatformId");
        const productName = localStorage.getItem("selectedProductName");

        const hostingItem = {
            productId: platformId, // Hosting hizmeti ID'si (cpanelId veya pleskId)
            domain: domain, // Hosting ile birlikte çalışacak domain adı
            action: "hosting", // İşlem türü olarak hosting eklendi
            itemName: productName, // Hosting ürün adı (örn. Cpanel veya Plesk)
            type: "hosting", // Ürün tipi hosting
            pers: [] // Ek bilgiler, gerekirse doldurulabilir
        };
        cart.push(hostingItem);
    }

    // Sepeti sunucuya gönder
    sendCartToServer(cart);

    // Eğer bir buton varsa buton durumunu güncelle
    if (button) {
        button.innerHTML = '<span class="fa-solid fa-shopping-basket"></span> Ödeme Yap';
        button.disabled = true;

        // 'onclick' özelliğini kaldır
        button.removeAttribute("onclick");

        // Tıklanınca belirli bir süre sonra yönlendirme yap
        button.addEventListener("click", function (e) {
            e.preventDefault(); // Tıklamayı hemen yönlendirmesin diye engelliyoruz.

            // Ödeme yapıldıktan sonra 3 saniye bekletip yönlendirme yapalım
            setTimeout(function () {
                window.location.href = "./sepet";
            }, 100);
        });
    }
}



// Sepeti sunucuya gönderme işlemi
function sendCartToServer(cart) {
    fetch('/require/pages/add-to-cart.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(cart), // Sepeti JSON formatında gönderiyoruz
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            console.log('Sepet başarıyla güncellendi:', data.cart);
            window.location.href = '/sepet';

        } else {
            console.error('Sepet güncellenirken hata oluştu:', data.message);
        }
    })
    .catch((error) => {
        console.error('Sepet güncellenirken hata oluştu:', error);
    });
}


// UUID fonksiyonu (benzersiz ID oluşturur)
function uuid() {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
        var r = (Math.random() * 16) | 0,
            v = c === "x" ? r : (r & 0x3) | 0x8;
        return v.toString(16);
    });
}


// Kartları dinlemek için
const domainCards = document.querySelectorAll(".domain-card");
domainCards.forEach((card) => {
    card.addEventListener("click", function () {
        domainCards.forEach((c) => c.classList.remove("active"));
        this.classList.add("active");
    });
});

</script>
