<?php
session_start();
// Güvenlik: Hata gösterimini kapat, loglamayı aç
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Güvenlik: Host Header Injection Önlemi
// SERVER_NAME sadece geçerli karakterler içermeli
$server_name = $_SERVER['SERVER_NAME'];
if (!preg_match('/^[a-zA-Z0-9.-]+$/', $server_name) || !filter_var($server_name, FILTER_VALIDATE_DOMAIN)) {
    $server_name = 'localhost';
}
$site_url = 'https://'.$server_name.'/';

require_once('./require/header.php');

// Güvenlik: Girdi Temizleme (Input Sanitization)
// Varsayılan sayfa 'index'
$file = isset($_GET["page"]) ? (string)$_GET["page"] : 'index';

// 1. Null Byte Temizliği
$file = str_replace(chr(0), '', $file);

// 2. Directory Traversal (Dizin Gezinme) Kontrolü
// İzin verilen karakterler: a-z, A-Z, 0-9, -, _, /
// Nokta (.) karakteri engellenerek ".." ve dosya uzantısı manipülasyonu önlenir.
// Dosya sisteminde nokta içeren (uzantı hariç) dosya olmadığı varsayılmıştır.
if (preg_match('/[^a-zA-Z0-9\/_-]/', $file)) {
    // Geçersiz karakter tespiti durumunda 404
    require_once('404.html');
    require_once('./require/footer.php');
    exit;
}

// "uzanti" modülü kontrolü
// strstr yerine daha güvenli olan strpos ile başlangıç kontrolü
if ($file === "uzanti" || strpos($file, "uzanti/") === 0) {
    $x = explode("/", $file);
    $uzanti = isset($x[1]) ? $x[1] : null;

    if ($uzanti !== null && $uzanti !== "") {
        if (file_exists("./uzantilar/index.php")) {
            require_once("./uzantilar/index.php");

            // Güvenlik: Anahtarı kontrol et
            if (isset($uzantilar) && is_array($uzantilar) && array_key_exists($uzanti, $uzantilar)) {
                $accross = $uzantilar[$uzanti];

                if (file_exists("./require/pages/uzanti.php")) {
                    require_once("./require/pages/uzanti.php");
                } else {
                    require_once('404.html');
                }
            } else {
                require_once('404.html');
            }
        } else {
             require_once('404.html');
        }
    } else {
        require_once('404.html');
    }
} else {
    // Normal Sayfa Yükleme
    // $file zaten yukarıda sanitize edildi (nokta yok, traversal yok).
    // Doğrudan pathe eklenir.
    $pagePath = "./require/pages/" . $file . ".php";

    if (file_exists($pagePath)) {
        require_once($pagePath);
    } else {
        require_once('404.html');
    }
}

require_once('./require/footer.php');
?>
